/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.actor.Sink;
import com.isencia.passerelle.actor.Source;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.AbstractBaseEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorSinkEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorSourceEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.CommentEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.CompositeActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DiagramEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DirectorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.PortEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.RelationEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexRelationEditPart;
import com.isencia.passerelle.workbench.model.ui.VertexRelation;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.moml.Vertex;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class EditPartFactory
implements org.eclipse.gef.EditPartFactory {
    private Set<AbstractBaseEditPart> parts = new HashSet<AbstractBaseEditPart>();
    private static Logger logger = LoggerFactory.getLogger(EditPartFactory.class);
    protected PasserelleModelMultiPageEditor parent;
    private CompositeActor actor;

    public Set<AbstractBaseEditPart> getParts() {
        return this.parts;
    }

    public MultiPageEditorPart getParent() {
        return this.parent;
    }

    public EditPartFactory(PasserelleModelMultiPageEditor passerelleModelMultiPageEditor) {
        this.parent = passerelleModelMultiPageEditor;
    }

    public EditPartFactory(PasserelleModelMultiPageEditor passerelleModelMultiPageEditor, CompositeActor compositeActor) {
        this.parent = passerelleModelMultiPageEditor;
        this.actor = compositeActor;
    }

    private Logger getLogger() {
        return logger;
    }

    public EditPart createEditPart(EditPart editPart, Object object) {
        ChangeListener changeListener = null;
        if (object instanceof Director) {
            changeListener = new DirectorEditPart();
        } else if (object instanceof TextAttribute) {
            changeListener = new CommentEditPart();
        } else if (object instanceof Vertex) {
            changeListener = new VertexEditPart();
        } else if (object instanceof IOPort) {
            changeListener = ((IOPort)object).isInput() ? new PortEditPart(true) : new PortEditPart(false);
        } else if (object instanceof Relation) {
            changeListener = new RelationEditPart();
        } else if (object instanceof VertexRelation) {
            changeListener = new VertexRelationEditPart();
        } else if (object instanceof TypedCompositeActor) {
            changeListener = ((TypedCompositeActor)object).getContainer() == null ? new DiagramEditPart(this.parent, this.actor) : new CompositeActorEditPart(editPart == null || editPart.getParent() == null, this.parent);
        } else if (object instanceof TypedAtomicActor) {
            changeListener = object instanceof Source ? new ActorSourceEditPart() : (object instanceof Sink ? new ActorSinkEditPart() : new ActorEditPart());
        }
        if (changeListener != null) {
            changeListener.setModel(object);
        } else {
            this.getLogger().error("Unable to create EditPart, requested model not supported");
        }
        if (changeListener instanceof AbstractBaseEditPart) {
            this.parts.add((AbstractBaseEditPart)changeListener);
        }
        return changeListener;
    }

    private Vertex getVertex(Relation relation) {
        Enumeration enumeration = relation.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            return (Vertex)e;
        }
        return null;
    }
}

