/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor;

import com.isencia.passerelle.model.util.IMomlClassLoader;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleContextMenuProvider;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.OutlinePartFactory;
import com.isencia.passerelle.workbench.model.ui.IPasserelleEditor;
import com.isencia.passerelle.workbench.model.ui.IPasserelleMultiPageEditor;
import com.isencia.passerelle.workbench.model.ui.command.RefreshCommand;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import com.isencia.passerelle.workbench.model.ui.utils.FileUtils;
import com.isencia.passerelle.workbench.model.utils.OSGClassLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.kernel.util.NamedObj;

public class PasserelleModelMultiPageEditor
extends MultiPageEditorPart
implements IPasserelleMultiPageEditor,
IResourceChangeListener {
    private RefreshCommand RefreshCommand;
    protected OutlinePage outlinePage;
    private static Logger logger = LoggerFactory.getLogger(PasserelleModelMultiPageEditor.class);
    private CompositeActor model = new CompositeActor();
    protected boolean editorSaving = false;
    private ResourceTracker resourceListener = new ResourceTracker();
    private List<CompositeActor> pages = new ArrayList<CompositeActor>();
    private PasserelleModelEditor editor;
    private Font font;
    private StyledText text;
    private TextEditor textEditor;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart != PasserelleModelMultiPageEditor.this) {
                return;
            }
            EclipseUtils.getFile((IEditorInput)PasserelleModelMultiPageEditor.this.getEditorInput()).exists();
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };

    public IPasserelleEditor getSelectedPage() {
        return this.editor;
    }

    public DefaultEditDomain getDefaultEditDomain() {
        return new DefaultEditDomain((IEditorPart)this);
    }

    private RefreshCommand getRefreshCommand() {
        if (this.RefreshCommand == null) {
            this.RefreshCommand = new RefreshCommand();
            return this.RefreshCommand;
        }
        return this.RefreshCommand;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IContentOutlinePage.class) {
            this.outlinePage = new OutlinePage((EditPartViewer)new TreeViewer());
            return this.outlinePage;
        }
        return super.getAdapter(clazz);
    }

    public Logger getLogger() {
        return logger;
    }

    public CompositeActor getDiagram() {
        return this.model;
    }

    public void removePage(int n) {
        super.removePage(n);
        this.pages.remove(n);
    }

    public int getPageIndex(CompositeActor compositeActor) {
        int n = 0;
        while (n < this.pages.size()) {
            if (compositeActor == this.pages.get(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean containsModel(TypedCompositeActor typedCompositeActor) {
        return this.getPageIndex((CompositeActor)typedCompositeActor) == -1;
    }

    public IEditorPart getEditor(int n) {
        return super.getEditor(n);
    }

    public int addPage(TypedCompositeActor typedCompositeActor, IEditorPart iEditorPart, IEditorInput iEditorInput) throws PartInitException {
        int n = super.addPage(iEditorPart, iEditorInput);
        this.pages.add((CompositeActor)typedCompositeActor);
        return n;
    }

    public PasserelleModelEditor getEditor() {
        return this.editor;
    }

    public PasserelleModelMultiPageEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void createPages() {
        try {
            this.createWorkflowPage();
            this.textEditor = new TextEditor(){

                public boolean isEditable() {
                    return false;
                }
            };
            this.addPage(1, (IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(1, "XML");
        }
        catch (PartInitException partInitException) {
            logger.error("Cannot open passerelle editor " + this.getEditorInput().getName(), (Throwable)partInitException);
        }
    }

    private void createWorkflowPage() throws PartInitException {
        this.editor = new PasserelleModelEditor(this, this.model);
        int n = this.addPage((IEditorPart)this.editor, this.getEditorInput());
        this.editor.setIndex(n);
        this.setPageText(n, "Workflow");
        this.pages.add(0, this.editor.getDiagram());
    }

    void removePage(PasserelleModelEditor passerelleModelEditor) {
        try {
            this.removePage(passerelleModelEditor.getIndex());
            int n = this.addPage((IEditorPart)passerelleModelEditor, this.getEditorInput());
            this.setPageText(n, passerelleModelEditor.getTitle());
        }
        catch (PartInitException partInitException) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)partInitException.getStatus());
        }
    }

    public void setText(int n, String string) {
        this.setPageText(n, string);
    }

    public void doSave(final IProgressMonitor iProgressMonitor) {
        this.editorSaving = true;
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                CompositeActor compositeActor = PasserelleModelMultiPageEditor.this.getDiagram();
                StringWriter stringWriter = new StringWriter();
                compositeActor.exportMoML((Writer)stringWriter);
                IFile iFile = EclipseUtils.getIFile((IEditorInput)PasserelleModelMultiPageEditor.this.getEditorInput());
                if (iFile != null) {
                    iFile.setContents((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes()), true, false, iProgressMonitor);
                } else {
                    File file = EclipseUtils.getFile((IEditorInput)PasserelleModelMultiPageEditor.this.getEditorInput());
                    FileUtils.write((File)file, (String)stringWriter.toString());
                }
            }
        });
        this.getEditor(0).doSave(iProgressMonitor);
        for (CompositeActor compositeActor : this.pages) {
            int n = this.getPageIndex(compositeActor);
            if (n == -1 || n == 0) continue;
            IEditorPart iEditorPart = this.getEditor(this.getPageIndex(compositeActor));
            iEditorPart.doSave(iProgressMonitor);
        }
        this.editorSaving = false;
    }

    public void doSaveAs() {
        this.performSaveAs();
        for (CompositeActor compositeActor : this.pages) {
            int n = this.getPageIndex(compositeActor);
            if (n == -1 || n == 0) continue;
            IEditorPart iEditorPart = this.getEditor(n);
            iEditorPart.doSaveAs();
            this.setPageText(0, iEditorPart.getTitle());
            this.setInput(iEditorPart.getEditorInput());
        }
    }

    public void gotoMarker(IMarker iMarker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)iMarker);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected boolean performSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        saveAsDialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        saveAsDialog.open();
        IPath iPath = saveAsDialog.getResult();
        if (iPath == null) {
            return false;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IFile iFile = iWorkspace.getRoot().getFile(iPath);
        if (!iFile.exists()) {
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor iProgressMonitor) {
                    try {
                        CompositeActor compositeActor = PasserelleModelMultiPageEditor.this.getDiagram();
                        StringWriter stringWriter = new StringWriter();
                        compositeActor.exportMoML((Writer)stringWriter);
                        iFile.create((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes()), true, iProgressMonitor);
                        stringWriter.close();
                    }
                    catch (Exception exception) {
                        PasserelleModelMultiPageEditor.this.getLogger().error("Error saving model file : " + iFile.getName(), (Throwable)exception);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
            }
            catch (Exception exception) {
                this.getLogger().error("Error showing progress monitor during saving of model file : " + iFile.getName(), (Throwable)exception);
            }
        }
        try {
            this.superSetInput((IEditorInput)new FileEditorInput(iFile));
        }
        catch (Exception exception) {
            this.getLogger().error("Error during re-read of saved model file : " + iFile.getName(), (Throwable)exception);
        }
        return true;
    }

    protected void pageChange(int n) {
        this.getRefreshCommand().setModel((NamedObj)this.getDiagram());
        this.getRefreshCommand().execute();
        if (this.outlinePage != null) {
            this.outlinePage.switchThumbnail(n);
        }
        if (n == 1) {
            this.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        super.pageChange(n);
    }

    public void resourceChanged(final IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = PasserelleModelMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    int n = 0;
                    while (n < iWorkbenchPageArray.length) {
                        if (((FileEditorInput)PasserelleModelMultiPageEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)iResourceChangeEvent.getResource())) {
                            IEditorPart iEditorPart = iWorkbenchPageArray[n].findEditor(PasserelleModelMultiPageEditor.this.editor.getEditorInput());
                            iWorkbenchPageArray[n].closeEditor(iEditorPart, true);
                        }
                        ++n;
                    }
                }
            });
        }
    }

    void setFont() {
        FontDialog fontDialog = new FontDialog(this.getSite().getShell());
        fontDialog.setFontList(this.text.getFont().getFontData());
        FontData fontData = fontDialog.open();
        if (fontData != null) {
            if (this.font != null) {
                this.font.dispose();
            }
            this.font = new Font((Device)this.text.getDisplay(), fontData);
            this.text.setFont(this.font);
        }
    }

    public void setDiagram(CompositeActor compositeActor) {
        this.model = compositeActor;
    }

    protected void superSetInput(IEditorInput iEditorInput) {
        IFile iFile;
        if (this.getEditorInput() != null) {
            iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            iFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.setInput(iEditorInput);
        if (this.getEditorInput() != null) {
            iFile = EclipseUtils.getIFile((IEditorInput)iEditorInput);
            if (iFile != null) {
                iFile.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
            }
            this.setPartName(iEditorInput.getName());
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        block14: {
            this.superSetInput(iEditorInput);
            File file = EclipseUtils.getFile((IEditorInput)iEditorInput);
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    MoMLParser moMLParser = new MoMLParser(null, (IMomlClassLoader)new OSGClassLoader());
                    CompositeActor compositeActor = (CompositeActor)moMLParser.parse(null, (InputStream)fileInputStream);
                    this.setDiagram(compositeActor);
                }
                catch (Exception exception) {
                    this.getLogger().error("Error during reading/parsing of model file : " + file.getName(), (Throwable)exception);
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void closeEditor(boolean bl) {
        this.getSite().getPage().closeEditor((IEditorPart)this, bl);
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.partListener = null;
        IFile iFile = EclipseUtils.getIFile((IEditorInput)this.getEditorInput());
        if (iFile != null) {
            iFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.dispose();
    }

    protected void setSite(IWorkbenchPartSite iWorkbenchPartSite) {
        super.setSite(iWorkbenchPartSite);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    public CompositeActor getSelectedContainer() {
        IPasserelleEditor iPasserelleEditor = this.getSelectedPage();
        if (iPasserelleEditor != null && iPasserelleEditor.getContainer() != null) {
            return iPasserelleEditor.getContainer();
        }
        return this.getDiagram();
    }

    public void selectPage(CompositeActor compositeActor) {
        int n = this.getPageIndex(compositeActor);
        if (n != -1) {
            this.setActivePage(n);
        } else {
            this.setActivePage(0);
        }
    }

    class OutlinePage
    extends ContentOutlinePage
    implements IAdaptable {
        private PageBook pageBook;
        private Control outline;
        private Canvas overview;
        private IAction showOutlineAction;
        private IAction showOverviewAction;
        static final int ID_OUTLINE = 0;
        static final int ID_OVERVIEW = 1;
        private Thumbnail thumbnail;
        private DisposeListener disposeListener;
        private int index;
        private LightweightSystem lws;
        private Map<PasserelleModelEditor, Thumbnail> thumbnails;
        private PasserelleModelEditor editor;

        public OutlinePage(EditPartViewer editPartViewer) {
            super(editPartViewer);
            this.thumbnails = new HashMap<PasserelleModelEditor, Thumbnail>();
        }

        public void init(IPageSite iPageSite) {
            super.init(iPageSite);
            this.editor = (PasserelleModelEditor)PasserelleModelMultiPageEditor.this.getEditor(0);
        }

        protected void configureOutlineViewer() {
            this.getViewer().setEditDomain((EditDomain)this.editor.getEditDomain());
            this.getViewer().setEditPartFactory((EditPartFactory)new OutlinePartFactory(PasserelleModelMultiPageEditor.this));
            PasserelleContextMenuProvider passerelleContextMenuProvider = new PasserelleContextMenuProvider(this.getViewer(), this.editor.getActionRegistry());
            this.getViewer().setContextMenu((MenuManager)passerelleContextMenuProvider);
            this.getSite().registerContextMenu("com.isencia.passerelle.workbench.model.editor.ui.editor.outline.contextmenu", (MenuManager)passerelleContextMenuProvider, this.getSite().getSelectionProvider());
            this.getViewer().setKeyHandler(this.editor.getCommonKeyHandler());
            IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
            this.showOutlineAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(0);
                }
            };
            this.showOutlineAction.setImageDescriptor(Activator.getImageDescriptor("icons/outline.gif"));
            iToolBarManager.add(this.showOutlineAction);
            this.showOverviewAction = new Action(){

                public void run() {
                    OutlinePage.this.showPage(1);
                }
            };
            this.showOverviewAction.setImageDescriptor(Activator.getImageDescriptor("icons/overview.gif"));
            iToolBarManager.add(this.showOverviewAction);
            this.showPage(1);
        }

        public void createControl(Composite composite) {
            this.pageBook = new PageBook(composite, 0);
            this.outline = this.getViewer().createControl((Composite)this.pageBook);
            this.overview = new Canvas((Composite)this.pageBook, 0);
            this.pageBook.showPage(this.outline);
            this.configureOutlineViewer();
            this.hookOutlineViewer();
            this.initializeOutlineViewer();
        }

        public void dispose() {
            this.unhookOutlineViewer();
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
                this.thumbnail = null;
            }
            super.dispose();
            PasserelleModelMultiPageEditor.this.outlinePage = null;
        }

        public Object getAdapter(Class clazz) {
            if (clazz == ZoomManager.class) {
                return this.editor.getGraphicalViewer().getProperty(ZoomManager.class.toString());
            }
            return null;
        }

        public Control getControl() {
            return this.pageBook;
        }

        protected void hookOutlineViewer() {
            this.editor.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        protected void initializeOutlineViewer() {
            this.setContents(PasserelleModelMultiPageEditor.this.getDiagram());
        }

        public void switchThumbnail(int n) {
            this.thumbnail = this.thumbnails.get((Object)this.editor);
            GraphicalViewer graphicalViewer = this.editor.getGraphicalViewer();
            if (this.lws == null) {
                this.lws = new LightweightSystem(this.overview);
            }
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(true);
                this.lws.setContents((IFigure)this.thumbnail);
            } else {
                this.thumbnail = this.createThumbnail(this.lws, graphicalViewer);
                this.thumbnails.put(this.editor, this.thumbnail);
            }
        }

        protected void initializeOverview() {
            this.editor = (PasserelleModelEditor)PasserelleModelMultiPageEditor.this.getEditor(0);
            this.thumbnail = this.thumbnails.get((Object)this.editor);
            this.lws = new LightweightSystem(this.overview);
            GraphicalViewer graphicalViewer = this.editor.getGraphicalViewer();
            this.thumbnail = this.createThumbnail(this.lws, graphicalViewer);
            this.thumbnails.put(this.editor, this.thumbnail);
        }

        private Thumbnail createThumbnail(LightweightSystem lightweightSystem, GraphicalViewer graphicalViewer) {
            RootEditPart rootEditPart;
            if (this.editor != null) {
                graphicalViewer = this.editor.getGraphicalViewer();
            }
            if ((rootEditPart = graphicalViewer.getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
                ScalableFreeformRootEditPart scalableFreeformRootEditPart = (ScalableFreeformRootEditPart)rootEditPart;
                this.thumbnail = new ScrollableThumbnail((Viewport)scalableFreeformRootEditPart.getFigure());
                this.thumbnail.setBorder((Border)new MarginBorder(3));
                this.thumbnail.setSource(scalableFreeformRootEditPart.getLayer((Object)"Printable Layers"));
                lightweightSystem.setContents((IFigure)this.thumbnail);
                this.disposeListener = new DisposeListener(){

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        if (OutlinePage.this.thumbnail != null) {
                            OutlinePage.this.thumbnail.deactivate();
                            OutlinePage.this.thumbnail = null;
                        }
                    }
                };
                this.editor.getEditor().addDisposeListener(this.disposeListener);
                return this.thumbnail;
            }
            return null;
        }

        public void setContents(Object object) {
            this.getViewer().setContents(object);
        }

        protected void showPage(int n) {
            if (n == 0) {
                this.showOutlineAction.setChecked(true);
                this.showOverviewAction.setChecked(false);
                this.pageBook.showPage(this.outline);
                if (this.thumbnail != null) {
                    this.thumbnail.setVisible(false);
                }
            } else if (n == 1) {
                if (this.thumbnail == null) {
                    this.initializeOverview();
                }
                this.showOutlineAction.setChecked(false);
                this.showOverviewAction.setChecked(true);
                this.pageBook.showPage((Control)this.overview);
                this.thumbnail.setVisible(true);
            }
        }

        protected void unhookOutlineViewer() {
            this.editor.getSelectionSynchronizer().removeViewer(this.getViewer());
            if (this.disposeListener != null && this.editor.getEditor() != null && !this.editor.getEditor().isDisposed()) {
                this.editor.getEditor().removeDisposeListener(this.disposeListener);
            }
        }
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                if (iResourceDelta != null) {
                    iResourceDelta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            IFile iFile = EclipseUtils.getIFile((IEditorInput)PasserelleModelMultiPageEditor.this.getEditorInput());
            if (iResourceDelta == null || !iResourceDelta.getResource().equals((Object)iFile)) {
                return true;
            }
            if (iResourceDelta.getKind() == 2) {
                Display display = PasserelleModelMultiPageEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & iResourceDelta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!PasserelleModelMultiPageEditor.this.isDirty()) {
                                PasserelleModelMultiPageEditor.this.closeEditor(false);
                            }
                        }
                    });
                } else {
                    final IFile iFile2 = ResourcesPlugin.getWorkspace().getRoot().getFile(iResourceDelta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PasserelleModelMultiPageEditor.this.superSetInput((IEditorInput)new FileEditorInput(iFile2));
                        }
                    });
                }
            } else if (iResourceDelta.getKind() == 4 && !PasserelleModelMultiPageEditor.this.editorSaving) {
                final IFile iFile3 = ResourcesPlugin.getWorkspace().getRoot().getFile(iResourceDelta.getFullPath());
                Display display = PasserelleModelMultiPageEditor.this.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PasserelleModelMultiPageEditor.this.setInput((IEditorInput)new FileEditorInput(iFile3));
                    }
                });
            }
            return false;
        }
    }
}

