/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.visitors.scope;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorWithChildrenVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFoldingVisitor
extends EasyASTIteratorWithChildrenVisitor {
    public static CodeFoldingVisitor create(SimpleNode root) {
        CodeFoldingVisitor visitor = new CodeFoldingVisitor();
        try {
            root.accept(visitor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return visitor;
    }

    @Override
    public Object visitIf(If node) throws Exception {
        ASTEntry entry = this.before(node);
        this.parents.push((Object)entry);
        this.traverse(node);
        this.after(entry);
        this.parents.pop();
        return null;
    }

    @Override
    protected void doAddNode(ASTEntry entry) {
        ASTEntry parent = entry.parent;
        if (entry.node instanceof If) {
            If entryIf = (If)entry.node;
            if (parent != null && parent.node instanceof If) {
                If parentIf = (If)parent.node;
                if (parentIf.orelse != null && parentIf.orelse.body != null && parentIf.orelse.body.length > 0 && parentIf.orelse.body[0] == entryIf) {
                    parent.endLine = entry.node.beginLine - 1;
                    if (entry.parent != null) {
                        entry.parent = entry.parent.parent;
                    }
                    super.doAddNode(entry);
                    return;
                }
            }
        }
        super.doAddNode(entry);
    }

    @Override
    protected void after(ASTEntry entry) {
        super.after(entry);
        if (entry.node instanceof If) {
            If entryIf = (If)entry.node;
            this.checkElse(entryIf, entry);
        }
    }

    private void checkElse(If entryIf, ASTEntry parentIf) {
        stmtType firstOrElseStmt;
        if (entryIf.orelse != null && entryIf.orelse.body != null && entryIf.orelse.body.length > 0 && !((firstOrElseStmt = entryIf.orelse.body[0]) instanceof If) && firstOrElseStmt != null) {
            If generatedIf = new If(new BoolOp(1, new exprType[0]), new stmtType[0], new suiteType(new stmtType[0]));
            generatedIf.beginLine = firstOrElseStmt.beginLine - 1;
            generatedIf.beginColumn = 1;
            ASTEntry generatedEntry = this.createEntry();
            generatedEntry.endLine = parentIf.endLine;
            parentIf.endLine = generatedIf.beginLine - 1;
            generatedEntry.node = generatedIf;
            if (generatedEntry.parent != null) {
                generatedEntry.parent = generatedEntry.parent.parent;
            }
            super.doAddNode(generatedEntry);
        }
    }

    @Override
    public Object visitFor(For node) throws Exception {
        return this.defaultVisit(node);
    }

    @Override
    public Object visitWhile(While node) throws Exception {
        return this.defaultVisit(node);
    }

    @Override
    public Object visitTryExcept(TryExcept node) throws Exception {
        return this.defaultVisit(node);
    }

    @Override
    public Object visitTryFinally(TryFinally node) throws Exception {
        return this.defaultVisit(node);
    }

    @Override
    public Object visitWith(With node) throws Exception {
        return this.defaultVisit(node);
    }

    @Override
    public Object visitImport(Import node) throws Exception {
        this.atomic(node);
        return null;
    }

    @Override
    public Object visitImportFrom(ImportFrom node) throws Exception {
        this.atomic(node);
        return null;
    }

    @Override
    public Object visitStr(Str node) throws Exception {
        this.atomic(node);
        return null;
    }

    @Override
    protected ASTEntry atomic(SimpleNode node) {
        try {
            this.unhandled_node(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return super.atomic(node);
    }

    private Object defaultVisit(SimpleNode node) throws Exception {
        this.unhandled_node(node);
        ASTEntry entry = this.before(node);
        this.parents.push((Object)entry);
        this.traverse(node);
        this.after(entry);
        this.parents.pop();
        return null;
    }

    @Override
    public List<ASTEntry> getAsList(Class ... classes) {
        ArrayList<ASTEntry> newList = new ArrayList<ASTEntry>();
        for (ASTEntryWithChildren entry : this.nodes) {
            this.checkEntry(newList, entry, classes);
        }
        return newList;
    }

    private void checkEntry(List<ASTEntry> newList, ASTEntryWithChildren entry, Class ... classes) {
        if (this.isFromClass(entry.node, classes)) {
            newList.add(entry);
        }
        if (entry.children != null) {
            for (ASTEntry aSTEntry : entry.children) {
                this.checkEntry(newList, (ASTEntryWithChildren)aSTEntry, classes);
            }
        }
    }
}

