/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class BaseImportWizardSecondPage
extends WizardPage
implements IModelProviderListener {
    protected static final String SETTINGS_ADD_FRAGMENTS = "addFragments";
    protected static final String SETTINGS_AUTOBUILD = "autobuild";
    protected PluginImportWizardFirstPage fPage1;
    protected IPluginModelBase[] fModels = new IPluginModelBase[0];
    private Object fImportSource;
    protected Button fAddFragmentsButton;
    private Button fAutoBuildButton;
    protected TableViewer fImportListViewer;
    private boolean fRefreshNeeded = true;

    public BaseImportWizardSecondPage(String pageName, PluginImportWizardFirstPage page) {
        super(pageName);
        this.fPage1 = page;
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        PDECore.getDefault().getModelManager().getExternalModelManager().addModelProviderListener((IModelProviderListener)this);
    }

    protected Composite createImportList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.ImportWizard_DetailedPage_importList);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fImportListViewer = new TableViewer(table);
        this.fImportListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fImportListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fImportListViewer.setInput((Object)PDECore.getDefault().getModelManager().getExternalModelManager());
        this.fImportListViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        return container;
    }

    protected Composite createComputationsOption(Composite parent, int span) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(5, 0).create());
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        composite.setLayoutData((Object)gd);
        this.fAddFragmentsButton = new Button(composite, 32);
        this.fAddFragmentsButton.setText(PDEUIMessages.ImportWizard_SecondPage_addFragments);
        this.fAddFragmentsButton.setLayoutData((Object)new GridData(768));
        if (this.getDialogSettings().get(SETTINGS_ADD_FRAGMENTS) != null) {
            this.fAddFragmentsButton.setSelection(this.getDialogSettings().getBoolean(SETTINGS_ADD_FRAGMENTS));
        } else {
            this.fAddFragmentsButton.setSelection(true);
        }
        if (!PDEPlugin.getWorkspace().isAutoBuilding()) {
            this.fAutoBuildButton = new Button(composite, 32);
            this.fAutoBuildButton.setText(PDEUIMessages.BaseImportWizardSecondPage_autobuild);
            this.fAutoBuildButton.setLayoutData((Object)new GridData(768));
            this.fAutoBuildButton.setSelection(this.getDialogSettings().getBoolean(SETTINGS_AUTOBUILD));
        }
        return composite;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        PDECore.getDefault().getModelManager().getExternalModelManager().removeModelProviderListener((IModelProviderListener)this);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.isRefreshNeeded()) {
            this.fModels = this.fPage1.getModels();
            this.refreshPage();
        }
    }

    protected abstract void refreshPage();

    protected boolean isRefreshNeeded() {
        if (this.fRefreshNeeded) {
            this.fRefreshNeeded = false;
            this.fImportSource = this.fPage1.getImportSource();
            return true;
        }
        Object currSource = this.fPage1.getImportSource();
        if (this.fImportSource == null || !this.fImportSource.equals(currSource)) {
            this.fImportSource = this.fPage1.getImportSource();
            return true;
        }
        return this.fPage1.isRefreshNeeded();
    }

    private IPluginModelBase findModel(String id) {
        int i = 0;
        while (i < this.fModels.length) {
            String modelId = this.fModels[i].getPluginBase().getId();
            if (modelId != null && modelId.equals(id)) {
                return this.fModels[i];
            }
            ++i;
        }
        return null;
    }

    private IFragmentModel[] findFragments(IPlugin plugin) {
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < this.fModels.length) {
            if (this.fModels[i] instanceof IFragmentModel) {
                IFragment fragment = ((IFragmentModel)this.fModels[i]).getFragment();
                if (plugin.getId().equalsIgnoreCase(fragment.getPluginId())) {
                    result.add(this.fModels[i]);
                }
            }
            ++i;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    protected void addPluginAndDependencies(IPluginModelBase model, ArrayList selected, boolean addFragments) {
        boolean containsVariable = false;
        if (!selected.contains(model)) {
            selected.add(model);
            boolean hasextensibleAPI = ClasspathUtilCore.hasExtensibleAPI((IPluginModelBase)model);
            if (!addFragments && !hasextensibleAPI && model instanceof IPluginModel) {
                IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
                int i = 0;
                while (i < libraries.length) {
                    if (ClasspathUtilCore.containsVariables((String)libraries[i].getName())) {
                        containsVariable = true;
                        break;
                    }
                    ++i;
                }
            }
            this.addDependencies(model, selected, addFragments || containsVariable || hasextensibleAPI);
        }
    }

    protected void addDependencies(IPluginModelBase model, ArrayList selected, boolean addFragments) {
        IPluginModelBase found;
        IPluginImport[] required = model.getPluginBase().getImports();
        if (required.length > 0) {
            int i = 0;
            while (i < required.length) {
                found = this.findModel(required[i].getId());
                if (found != null) {
                    this.addPluginAndDependencies(found, selected, addFragments);
                }
                ++i;
            }
        }
        if (addFragments) {
            if (model instanceof IPluginModel) {
                IFragmentModel[] fragments = this.findFragments(((IPluginModel)model).getPlugin());
                int i = 0;
                while (i < fragments.length) {
                    this.addPluginAndDependencies((IPluginModelBase)fragments[i], selected, addFragments);
                    ++i;
                }
            } else {
                IFragment fragment = ((IFragmentModel)model).getFragment();
                found = this.findModel(fragment.getPluginId());
                if (found != null) {
                    this.addPluginAndDependencies(found, selected, addFragments);
                }
            }
        }
    }

    public IPluginModelBase[] getModelsToImport() {
        TableItem[] items = this.fImportListViewer.getTable().getItems();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            result.add(items[i].getData());
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTINGS_ADD_FRAGMENTS, this.fAddFragmentsButton.getSelection());
        if (this.fAutoBuildButton != null) {
            settings.put(SETTINGS_AUTOBUILD, this.fAutoBuildButton.getSelection());
        }
    }

    public void modelsChanged(IModelProviderEvent event) {
        this.fRefreshNeeded = true;
    }

    public boolean forceAutoBuild() {
        return this.fAutoBuildButton != null && this.getDialogSettings().getBoolean(SETTINGS_AUTOBUILD);
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return new Object[0];
        }
    }
}

