/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.correction.AbstractPDEMarkerResolution;
import org.eclipse.pde.internal.ui.correction.ResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class PDEQuickAssistAssistant
extends QuickAssistAssistant {
    private Image fCreateImage;
    private Image fRenameImage;
    private Image fRemoveImage;

    public PDEQuickAssistAssistant() {
        this.setQuickAssistProcessor(new PDEQuickAssistProcessor());
        this.fCreateImage = PDEPluginImages.DESC_ADD_ATT.createImage();
        this.fRemoveImage = PDEPluginImages.DESC_DELETE.createImage();
        this.fRenameImage = PDEPluginImages.DESC_REFRESH.createImage();
        this.setInformationControlCreator((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            public IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, null);
            }
        });
    }

    public void dispose() {
        this.fCreateImage.dispose();
        this.fRemoveImage.dispose();
        this.fRenameImage.dispose();
    }

    class PDECompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension3 {
        Position fPosition;
        IMarkerResolution fResolution;
        IMarker fMarker;

        public PDECompletionProposal(IMarkerResolution resolution, Position pos, IMarker marker) {
            this.fPosition = pos;
            this.fResolution = resolution;
            this.fMarker = marker;
        }

        public void apply(IDocument document) {
            this.fResolution.run(this.fMarker);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fPosition.offset, 0);
        }

        public String getAdditionalProposalInfo() {
            if (this.fResolution instanceof IMarkerResolution2) {
                return ((IMarkerResolution2)this.fResolution).getDescription();
            }
            return null;
        }

        public String getDisplayString() {
            return this.fResolution.getLabel();
        }

        public Image getImage() {
            if (this.fResolution instanceof AbstractPDEMarkerResolution) {
                switch (((AbstractPDEMarkerResolution)this.fResolution).getType()) {
                    case 1: {
                        return PDEQuickAssistAssistant.this.fCreateImage;
                    }
                    case 3: {
                        return PDEQuickAssistAssistant.this.fRemoveImage;
                    }
                    case 2: {
                        return PDEQuickAssistAssistant.this.fRenameImage;
                    }
                }
            }
            if (this.fResolution instanceof IMarkerResolution2) {
                IMarkerResolution2 resolution = (IMarkerResolution2)this.fResolution;
                return resolution.getImage();
            }
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public IInformationControlCreator getInformationControlCreator() {
            return null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return 0;
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return null;
        }
    }

    class PDEQuickAssistProcessor
    implements IQuickAssistProcessor {
        ResolutionGenerator fGenerator = new ResolutionGenerator();
        HashMap fResMap = new HashMap();

        PDEQuickAssistProcessor() {
        }

        public String getErrorMessage() {
            return null;
        }

        public boolean canFix(Annotation annotation) {
            boolean canFix;
            if (!(annotation instanceof SimpleMarkerAnnotation)) {
                return false;
            }
            ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>(5);
            IMarker marker = ((SimpleMarkerAnnotation)annotation).getMarker();
            IMarkerResolution[] localResolutions = this.fGenerator.getResolutions(marker);
            resolutions.addAll(Arrays.asList(localResolutions));
            IMarkerResolution[] contributedResolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
            int i = 0;
            while (i < contributedResolutions.length) {
                IMarkerResolution resolution = contributedResolutions[i];
                if (!(resolution instanceof AbstractPDEMarkerResolution)) {
                    resolutions.add(contributedResolutions[i]);
                }
                ++i;
            }
            boolean bl = canFix = resolutions.size() > 0;
            if (canFix && !this.fResMap.containsKey(marker)) {
                this.fResMap.put(marker, resolutions.toArray(new IMarkerResolution[resolutions.size()]));
            }
            return canFix;
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            return false;
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            IAnnotationModel amodel = invocationContext.getSourceViewer().getAnnotationModel();
            IDocument doc = invocationContext.getSourceViewer().getDocument();
            int offset = invocationContext.getOffset();
            Iterator it = amodel.getAnnotationIterator();
            ArrayList<PDECompletionProposal> list = new ArrayList<PDECompletionProposal>();
            while (it.hasNext()) {
                SimpleMarkerAnnotation annotation;
                IMarker marker;
                IMarkerResolution[] mapping;
                Object key = it.next();
                if (!(key instanceof SimpleMarkerAnnotation) || (mapping = (IMarkerResolution[])this.fResMap.get(marker = (annotation = (SimpleMarkerAnnotation)key).getMarker())) == null) continue;
                Position pos = amodel.getPosition((Annotation)annotation);
                try {
                    int line = doc.getLineOfOffset(pos.getOffset());
                    int start = pos.getOffset();
                    String delim = doc.getLineDelimiter(line);
                    int delimLength = delim != null ? delim.length() : 0;
                    int end = doc.getLineLength(line) + start - delimLength;
                    if (offset < start || offset > end) continue;
                    int i = 0;
                    while (i < mapping.length) {
                        list.add(new PDECompletionProposal(mapping[i], pos, marker));
                        ++i;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return list.toArray(new ICompletionProposal[list.size()]);
        }
    }
}

