/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net.requestreply;

import com.isencia.message.ChannelException;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.message.ReceiverChannel;
import com.isencia.message.extractor.IMessageExtractor;
import com.isencia.message.generator.IMessageGenerator;
import com.isencia.message.interceptor.IMessageInterceptorChain;
import com.isencia.message.net.SocketReceiverChannel;
import com.isencia.message.net.SocketSenderChannel;
import com.isencia.message.requestreply.IMessage;
import com.isencia.message.requestreply.IRequestReplier;
import com.isencia.message.requestreply.IRequestReplyChannel;
import com.isencia.message.requestreply.ReceiverSenderChannelPair;
import com.isencia.message.requestreply.RequestReplier;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketServerRequestReplier
extends ReceiverChannel
implements IRequestReplyChannel {
    private static final Logger logger = LoggerFactory.getLogger(SocketServerRequestReplier.class);
    private IMessageInterceptorChain interceptorChainForResponse = null;
    private ServerSocket sSocket = null;
    private IMessageExtractor extractor = null;
    private IMessageGenerator generator = null;
    private IRequestReplier reqReplier = null;

    public SocketServerRequestReplier(ServerSocket serverSocket, IMessageExtractor iMessageExtractor, IMessageGenerator iMessageGenerator) {
        if (serverSocket != null) {
            this.setSocket(serverSocket);
        }
        this.setExtractor(iMessageExtractor);
        this.setGenerator(iMessageGenerator);
        this.reqReplier = new RequestReplier();
    }

    public ServerSocket getSocket() {
        return this.sSocket;
    }

    public void setSocket(ServerSocket serverSocket) {
        this.sSocket = serverSocket;
    }

    @Override
    public void run() {
        if (logger.isTraceEnabled()) {
            logger.trace("run() - entry");
        }
        while (true) {
            Socket socket = null;
            try {
                socket = this.getSocket().accept();
            }
            catch (SocketException socketException) {
                logger.info("run() - " + socketException.getMessage() + ". Terminating...");
                break;
            }
            catch (IOException iOException) {
                logger.info("run() - " + iOException.getMessage() + ". Terminating...");
                break;
            }
            logger.info("run() - Accepted connection request. Socket: " + socket);
            if (this.isInterrupted()) break;
            IMessageExtractor iMessageExtractor = null;
            IMessageGenerator iMessageGenerator = null;
            try {
                iMessageExtractor = this.getExtractor().cloneExtractor();
                iMessageGenerator = this.getGenerator().cloneGenerator();
                SocketReceiverChannel socketReceiverChannel = new SocketReceiverChannel(socket, iMessageExtractor);
                SocketSenderChannel socketSenderChannel = new SocketSenderChannel(socket, iMessageGenerator);
                socketSenderChannel.setInterceptorChainOnEnter(this.interceptorChainForResponse);
                ReceiverSenderChannelPair receiverSenderChannelPair = new ReceiverSenderChannelPair(socketReceiverChannel, socketSenderChannel);
                this.reqReplier.addChannelPair(receiverSenderChannelPair);
                receiverSenderChannelPair.open();
                socketReceiverChannel.start();
            }
            catch (ChannelException channelException) {
                logger.error("run() - Unable to start new channel", (Throwable)channelException);
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {}
        if (logger.isTraceEnabled()) {
            logger.trace("run() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        super.close();
        this.reqReplier.close();
        this.interrupt();
        try {
            this.getSocket().close();
        }
        catch (IOException iOException) {
            logger.error("close() - Error closing server socket", (Throwable)iOException);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    public IMessageExtractor getExtractor() {
        return this.extractor;
    }

    public void setExtractor(IMessageExtractor iMessageExtractor) {
        this.extractor = iMessageExtractor;
    }

    protected IMessageGenerator getGenerator() {
        return this.generator;
    }

    protected void setGenerator(IMessageGenerator iMessageGenerator) {
        this.generator = iMessageGenerator;
    }

    @Override
    public IMessage receiveRequest() throws NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("receiveRequest() - entry");
        }
        IMessage iMessage = this.reqReplier.receiveRequest();
        if (logger.isTraceEnabled()) {
            logger.trace("receiveRequest() - exit : " + iMessage);
        }
        return iMessage;
    }

    @Override
    protected Object doGetMessage() throws ChannelException, NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - entry");
        }
        Object object = this.reqReplier.receiveRequest().getMessage();
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - exit : " + object);
        }
        return object;
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        super.open();
        this.reqReplier.open();
        this.start();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public void sendResponse(Object object, Object object2) throws ChannelException {
        this.reqReplier.sendResponse(object, object2);
    }

    @Override
    public void setInterceptorChainForResponse(IMessageInterceptorChain iMessageInterceptorChain) {
        if (logger.isTraceEnabled()) {
            logger.trace("setInterceptorChainOnEnter() - entry - chain :" + iMessageInterceptorChain);
        }
        this.interceptorChainForResponse = iMessageInterceptorChain;
        if (logger.isTraceEnabled()) {
            logger.trace("setInterceptorChainOnEnter() - exit");
        }
    }
}

