/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.net;

import com.isencia.message.ChannelException;
import com.isencia.message.DefaultSenderChannelHandler;
import com.isencia.message.ISenderChannelHandler;
import com.isencia.message.SenderChannel;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastSenderChannel
extends SenderChannel {
    private static final Logger logger = LoggerFactory.getLogger(MulticastSenderChannel.class);
    private MulticastSocket socket = null;
    private int port = -1;
    private String groupName = "";
    private InetAddress group = null;
    private ISenderChannelHandler handler = null;

    public MulticastSenderChannel(MulticastSocket multicastSocket) throws ChannelException {
        if (multicastSocket != null) {
            this.socket = multicastSocket;
            this.setPort(multicastSocket.getLocalPort());
        }
    }

    public MulticastSenderChannel(String string, int n) throws ChannelException {
        this.setPort(n);
        this.setGroupName(string);
        this.handler = new DefaultSenderChannelHandler(this);
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        if (this.socket == null) {
            try {
                this.socket = new MulticastSocket(this.getPort());
            }
            catch (IOException iOException) {
                logger.error("open() - Socket construction failed on port " + this.port, (Throwable)iOException);
                throw new ChannelException("Socket construction failed on port " + this.port);
            }
        }
        if (!this.isOpen()) {
            super.open();
            this.handler.open();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        if (this.isOpen()) {
            super.close();
            this.handler.close();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    public MulticastSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.port;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("setGroupName() - entry :" + string);
        }
        try {
            this.group = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new ChannelException("Unknown host " + string);
        }
        this.groupName = string;
        if (logger.isTraceEnabled()) {
            logger.trace("setGroupName() - exit");
        }
    }

    public void setPort(int n) throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("setPort() - entry :" + n);
        }
        if (n < 0) {
            throw new ChannelException("Port (" + n + ") not set correctly");
        }
        this.port = n;
        if (logger.isTraceEnabled()) {
            logger.trace("setPort() - exit");
        }
    }

    protected InetAddress getGroup() {
        return this.group;
    }

    @Override
    protected void doSendMessage(Object object) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - entry :" + object);
        }
        byte[] byArray = object.toString().getBytes();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.getGroup(), this.getPort());
        this.socket.send(datagramPacket);
        if (logger.isTraceEnabled()) {
            logger.trace("doSendMessage() - exit");
        }
    }
}

