/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.mail;

import com.isencia.message.ChannelException;
import com.isencia.message.ReceiverChannel;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailReceiverChannel
extends ReceiverChannel {
    private static final Logger logger = LoggerFactory.getLogger(MailReceiverChannel.class);
    private URLName server = null;
    private Folder folder = null;
    private Message[] messages = null;
    private int messageOffset = 0;
    private int messageCount = 0;
    private boolean messageCountSend = false;
    private int messageType = 1;
    public static final int MESSAGES = 1;
    public static final int MESSAGE_COUNT = 2;
    public static final int NEW_MESSAGE_COUNT = 3;
    public static final int UNREAD_MESSAGE_COUNT = 4;

    public MailReceiverChannel(URLName uRLName) {
        this.server = uRLName;
    }

    @Override
    public void open() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        this.messageCountSend = false;
        if (this.server == null) {
            throw new ChannelException("Server not specified");
        }
        try {
            Session session = Session.getDefaultInstance((Properties)new Properties(), null);
            this.folder = session.getFolder(this.server);
            if (this.folder == null) {
                logger.debug("open() - Folder : " + this.server.getFile() + "not found");
                return;
            }
            this.folder.open(1);
            this.messageOffset = 0;
            switch (this.messageType) {
                case 1: {
                    this.messages = this.folder.getMessages();
                    logger.debug("open() - " + this.messages.length + " messages found");
                    break;
                }
                case 2: {
                    this.messageCount = this.folder.getMessageCount();
                    logger.debug("open() - " + this.messageCount + " messages found");
                    break;
                }
                case 3: {
                    this.messageCount = this.folder.getNewMessageCount();
                    logger.debug("open() - " + this.messageCount + " messages found");
                    break;
                }
                case 4: {
                    this.messageCount = this.folder.getUnreadMessageCount();
                    logger.debug("open() - " + this.messageCount + " messages found");
                    break;
                }
            }
        }
        catch (MessagingException messagingException) {
            throw new ChannelException(messagingException.toString());
        }
        super.open();
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public void close() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        super.close();
        try {
            logger.debug("Closing Channel");
            if (this.folder != null && this.folder.isOpen()) {
                logger.debug("Closing Folder");
            }
            this.folder.close(false);
            this.folder = null;
        }
        catch (MessagingException messagingException) {
            logger.error(messagingException.getMessage());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    @Override
    protected Object doGetMessage() throws ChannelException {
        if (logger.isTraceEnabled()) {
            logger.trace("doGetMessage() - entry");
        }
        String string = null;
        try {
            switch (this.messageType) {
                case 1: {
                    if (this.messageOffset >= this.messages.length) break;
                    string = this.messages[this.messageOffset++];
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    if (this.messageCountSend) break;
                    string = Integer.toString(this.messageCount);
                    this.messageCountSend = true;
                    break;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("doGetMessage() - exit : " + string);
            }
            return string;
        }
        catch (Exception exception) {
            throw new ChannelException(exception.getMessage());
        }
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int n) {
        this.messageType = n;
    }
}

