/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message.extractor;

import com.isencia.message.EndOfDataException;
import com.isencia.message.extractor.IMessageExtractor;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextLineMessageExtractor
implements IMessageExtractor {
    private static final Logger logger = LoggerFactory.getLogger(TextLineMessageExtractor.class);
    private static int defaultBuffSize = 256;
    private StringBuffer buffer = null;
    private char prevChar;
    private Reader reader;

    @Override
    public synchronized Object getMessage() {
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - entry");
        }
        if (!this.initialize()) {
            if (logger.isTraceEnabled()) {
                logger.trace("getMessage() - exit - not yet initialized! Returning null.");
            }
            return null;
        }
        while (true) {
            char c = '\uffff';
            try {
                c = this.readNextChar();
            }
            catch (EndOfDataException endOfDataException) {
                if (this.prevChar != '\n' && this.prevChar != '\uffff') break;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
            if (c == '\n' || c == '\r') {
                if (c == '\n') {
                    break;
                }
            } else if (c == '\uffff') {
                if (this.prevChar != '\n' && this.prevChar != '\uffff') {
                    break;
                }
            } else {
                this.buffer.append(c);
            }
            this.prevChar = c;
        }
        String string = this.buffer.toString();
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - exit - result :" + string);
        }
        return string;
    }

    @Override
    public boolean isOpen() {
        return this.reader != null;
    }

    private char readNextChar() throws EndOfDataException, Exception {
        try {
            int n = this.reader.read();
            if (n == -1) {
                throw new EndOfDataException();
            }
            return (char)n;
        }
        catch (EOFException eOFException) {
            throw new EndOfDataException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new EndOfDataException(iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("No reader specified");
        }
    }

    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                logger.error("close() - Error closing reader", (Throwable)iOException);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    private boolean initialize() {
        if (logger.isTraceEnabled()) {
            logger.trace("initialize() - entry");
        }
        this.buffer = new StringBuffer(defaultBuffSize);
        this.prevChar = (char)65535;
        if (logger.isTraceEnabled()) {
            logger.trace("initialize() - exit");
        }
        return true;
    }

    @Override
    public synchronized void open(Reader reader) {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        this.reader = reader;
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    @Override
    public IMessageExtractor cloneExtractor() {
        TextLineMessageExtractor textLineMessageExtractor = new TextLineMessageExtractor();
        return textLineMessageExtractor;
    }
}

