/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.message;

import com.isencia.message.ChannelException;
import com.isencia.message.IMessageProvider;
import com.isencia.message.IMessageSender;
import com.isencia.message.ISenderChannel;
import com.isencia.message.NoMoreMessagesException;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.FIFOQueue;
import com.isencia.util.IQueue;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancedMessageSender
implements IMessageSender,
IMessageProvider {
    private static final long MESSAGE_TIMEOUT = 10000L;
    private static final Logger logger = LoggerFactory.getLogger(BalancedMessageSender.class);
    private Collection channels = null;
    private boolean open = false;
    private IQueue queue = new FIFOQueue();

    public BalancedMessageSender() {
        this.channels = new ArrayList();
    }

    @Override
    public Collection getChannels() {
        return this.channels;
    }

    @Override
    public Object getMessage() throws NoMoreMessagesException {
        if (logger.isTraceEnabled()) {
            logger.trace("getMessage() - entry");
        }
        IQueue iQueue = this.queue;
        synchronized (iQueue) {
            try {
                Object object = this.queue.get();
                if (logger.isTraceEnabled()) {
                    logger.trace("getMessage() - exit - Result :" + object);
                }
                return object;
            }
            catch (EmptyQueueException emptyQueueException) {
                throw new NoMoreMessagesException(emptyQueueException.toString());
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChannel(ISenderChannel iSenderChannel) {
        Collection collection = this.channels;
        synchronized (collection) {
            this.channels.add(iSenderChannel);
            iSenderChannel.addProvider(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("close() - entry");
        }
        Collection collection = this.channels;
        synchronized (collection) {
            this.open = false;
            for (ISenderChannel iSenderChannel : this.channels) {
                try {
                    iSenderChannel.close();
                }
                catch (ChannelException channelException) {
                    logger.error("close() - Error closing channel", (Throwable)channelException);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("close() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasMessage() {
        IQueue iQueue = this.queue;
        synchronized (iQueue) {
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (logger.isTraceEnabled()) {
            logger.trace("open() - entry");
        }
        Collection collection = this.channels;
        synchronized (collection) {
            for (ISenderChannel iSenderChannel : this.getChannels()) {
                try {
                    iSenderChannel.open();
                }
                catch (ChannelException channelException) {
                    logger.error("open() - Error opening channel", (Throwable)channelException);
                }
            }
            this.open = true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("open() - exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChannel(ISenderChannel iSenderChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace("removeChannel() - entry - channel :" + iSenderChannel);
        }
        try {
            Collection collection = this.channels;
            synchronized (collection) {
                if (logger.isTraceEnabled()) {
                    logger.trace("removeChannel() - exit");
                }
                return this.channels.remove(iSenderChannel);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            logger.error("removechannel()", (Throwable)unsupportedOperationException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - entry - Message: " + object);
        }
        boolean bl = false;
        if (!this.open) {
            throw new IllegalStateException("sendMessage() - MessageSender is not open");
        }
        IQueue iQueue = this.queue;
        synchronized (iQueue) {
            bl = this.queue.put(object);
            if (bl) {
                for (ISenderChannel iSenderChannel : this.channels) {
                    logger.debug("sendMessage() - Send message on channel ");
                    iSenderChannel.messageAvailable();
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sendMessage() - exit");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasMessages() {
        IQueue iQueue = this.queue;
        synchronized (iQueue) {
            return !this.queue.isEmpty();
        }
    }
}

