/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIOPort;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class ModelUtils {
    public static Logger logger = LoggerFactory.getLogger(ModelUtils.class);

    public static final boolean isPort(String string) {
        return "com.isencia.passerelle.actor.general.InputIOPort".equals(string) || "com.isencia.passerelle.actor.general.OutputIOPort".equals(string);
    }

    public static final boolean isOutputPort(String string) {
        return "com.isencia.passerelle.actor.general.OutputIOPort".equals(string);
    }

    public static final boolean isInputPort(String string) {
        return "com.isencia.passerelle.actor.general.InputIOPort".equals(string);
    }

    public static Set<Relation> getConnectedRelations(Nameable nameable, ConnectionType connectionType) {
        return ModelUtils.getConnectedRelations(nameable, connectionType, false);
    }

    public static boolean containsVertex(Relation relation) {
        Enumeration enumeration = relation.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            return true;
        }
        return false;
    }

    public static Vertex getVertex(Relation relation) {
        Enumeration enumeration = relation.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            return (Vertex)e;
        }
        return null;
    }

    public static List<IOPort> getPorts(Relation relation, NamedObj namedObj) {
        ArrayList<IOPort> arrayList = new ArrayList<IOPort>();
        for (Object e : relation.linkedPortList()) {
            if (!((Port)e).getContainer().equals(namedObj)) continue;
            arrayList.add((IOPort)e);
        }
        return arrayList;
    }

    public static Set<Relation> getConnectedRelations(Nameable nameable, ConnectionType connectionType, boolean bl) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        if (nameable.getContainer() == null || !(nameable.getContainer() instanceof CompositeEntity)) {
            return Collections.EMPTY_SET;
        }
        CompositeEntity compositeEntity = (CompositeEntity)nameable.getContainer();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(compositeEntity.relationList());
        if (nameable instanceof TypedIOPort && bl && compositeEntity != null && compositeEntity.getContainer() != null) {
            arrayList.addAll(((CompositeEntity)compositeEntity.getContainer()).relationList());
        }
        if (arrayList == null || arrayList.size() == 0) {
            return Collections.EMPTY_SET;
        }
        for (Relation relation : arrayList) {
            List list = relation.linkedObjectsList();
            if (list == null || list.size() == 0) continue;
            for (Object e : list) {
                Port port;
                if (!(e instanceof Port) || !(port = (Port)e).getContainer().equals(nameable) && (!(nameable instanceof IOPort) || !port.equals((IOPort)nameable))) continue;
                if (connectionType.equals((Object)ConnectionType.SOURCE)) {
                    if ((!(port instanceof IOPort) || nameable instanceof IOPort || !((IOPort)port).isOutput()) && (!(nameable instanceof IOPort) || !((IOPort)port).isInput())) continue;
                    hashSet.add(relation);
                    continue;
                }
                if ((!(port instanceof IOPort) || nameable instanceof IOPort || !((IOPort)port).isInput()) && (!(nameable instanceof IOPort) || !((IOPort)port).isOutput())) continue;
                hashSet.add(relation);
            }
        }
        return hashSet;
    }

    public static List<Relation> getRelations(NamedObj namedObj) {
        new ArrayList();
        if (namedObj == null || !(namedObj instanceof CompositeEntity)) {
            return Collections.EMPTY_LIST;
        }
        List list = ((CompositeEntity)namedObj).relationList();
        return list;
    }

    public static double[] getLocation(NamedObj namedObj) {
        List list = namedObj.attributeList(Locatable.class);
        if (list == null || list.size() == 0) {
            return new double[]{0.0, 0.0};
        }
        Locatable locatable = (Locatable)list.get(0);
        return locatable.getLocation();
    }

    public static void setLocation(NamedObj namedObj, double[] dArray) {
        List list = namedObj.attributeList(Locatable.class);
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            Locatable locatable = (Locatable)list.get(0);
            try {
                locatable.setLocation(dArray);
                namedObj.attributeChanged((Attribute)list.get(0));
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("Unable to change location of component", (Throwable)illegalActionException);
            }
        } else {
            try {
                new Location(namedObj, "_location").setLocation(dArray);
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("Unable to change location of component", (Throwable)illegalActionException);
            }
            catch (NameDuplicationException nameDuplicationException) {
                logger.error("Duplicate name encountered during change location of component", (Throwable)nameDuplicationException);
            }
        }
    }

    public static boolean isPortOfActor(IOPort iOPort, Actor actor) {
        for (Object e : actor.inputPortList()) {
            if (e != iOPort) continue;
            return true;
        }
        for (Object e : actor.outputPortList()) {
            if (e != iOPort) continue;
            return true;
        }
        return false;
    }

    public static String findUniqueActorName(CompositeEntity compositeEntity, String string) {
        String string2 = string;
        if (compositeEntity == null) {
            return string2;
        }
        List list = compositeEntity.entityList();
        if (list == null || list.size() == 0) {
            return string2;
        }
        ComponentEntity componentEntity = compositeEntity.getEntity(string2);
        int n = 1;
        while (componentEntity != null) {
            string2 = String.valueOf(string) + "(" + n++ + ")";
            componentEntity = compositeEntity.getEntity(string2);
        }
        return string2;
    }

    private static String generateUniqueTextAttributeName(String string, NamedObj namedObj, int n, Class clazz) {
        try {
            String string2;
            String string3 = string2 = n != 0 ? String.valueOf(string) + "(" + n + ")" : string;
            if (namedObj.getAttribute(string2, clazz) == null) {
                return string2;
            }
            return ModelUtils.generateUniqueTextAttributeName(string, namedObj, ++n, clazz);
        }
        catch (IllegalActionException illegalActionException) {
            return string;
        }
    }

    private static String generateUniqueVertexName(String string, NamedObj namedObj, int n, Class clazz) {
        return "Vertex" + System.currentTimeMillis();
    }

    private static String generateUniquePortName(String string, CompositeEntity compositeEntity, int n) {
        String string2 = n != 0 ? String.valueOf(string) + "(" + n + ")" : string;
        boolean bl = false;
        Enumeration enumeration = compositeEntity.getPorts();
        while (enumeration.hasMoreElements()) {
            String string3 = ((Port)enumeration.nextElement()).getName();
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string2;
        }
        return ModelUtils.generateUniquePortName(string, compositeEntity, ++n);
    }

    public static String findUniqueName(CompositeEntity compositeEntity, Class clazz, String string) {
        if (clazz.getSimpleName().equals("Vertex")) {
            return ModelUtils.generateUniqueVertexName(clazz.getSimpleName(), (NamedObj)compositeEntity, 0, clazz);
        }
        if (clazz.getSimpleName().equals("TextAttribute")) {
            return ModelUtils.generateUniqueTextAttributeName(clazz.getSimpleName(), (NamedObj)compositeEntity, 0, clazz);
        }
        if (clazz.getSimpleName().equals("TypedIOPort")) {
            return ModelUtils.generateUniquePortName(string, compositeEntity, 0);
        }
        return ModelUtils.findUniqueActorName(compositeEntity, clazz.getSimpleName());
    }

    public static enum ConnectionType {
        SOURCE,
        TARGET;

    }
}

