/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Repeat
extends SDFTransformer {
    public Parameter numberOfTimes = new Parameter((NamedObj)this, "numberOfTimes", (Token)new IntToken(2));
    public Parameter blockSize;

    public Repeat(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.numberOfTimes.setTypeEquals((Type)BaseType.INT);
        this.blockSize = new Parameter((NamedObj)this, "blockSize", (Token)new IntToken(1));
        this.blockSize.setTypeEquals((Type)BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("blockSize");
        this.output_tokenProductionRate.setExpression("numberOfTimes*blockSize");
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numberOfTimes || attribute == this.blockSize) {
            int repetitions = ((IntToken)this.numberOfTimes.getToken()).intValue();
            int count = ((IntToken)this.blockSize.getToken()).intValue();
            if (repetitions < 1) {
                throw new IllegalActionException((Nameable)this.numberOfTimes, "The value of numberOfTimes must be positive, but was set to " + repetitions);
            }
            if (count < 1) {
                throw new IllegalActionException((Nameable)this.blockSize, "The value of blockSize must be positive, but was set to " + count);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        int repetitions = ((IntToken)this.numberOfTimes.getToken()).intValue();
        int count = ((IntToken)this.blockSize.getToken()).intValue();
        Token[] inputBlock = this.input.get(0, count);
        int i = 0;
        while (i < repetitions) {
            this.output.send(0, inputBlock, count);
            ++i;
        }
    }
}

