/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFConverter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class IntToBits
extends SDFConverter {
    public Parameter numberOfBits;

    public IntToBits(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)BaseType.INT);
        this.numberOfBits = new Parameter((NamedObj)this, "numberOfBits");
        this.numberOfBits.setExpression("32");
        this.output_tokenProductionRate.setExpression("numberOfBits");
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.numberOfBits) {
            int rate = ((IntToken)this.numberOfBits.getToken()).intValue();
            if (rate < 1 || rate > 32) {
                throw new IllegalActionException((Nameable)this, "Invalid number of bits: " + rate);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    public final void fire() throws IllegalActionException {
        super.fire();
        int rate = ((IntToken)this.numberOfBits.getToken()).intValue();
        BooleanToken[] bits = new BooleanToken[rate];
        IntToken token = (IntToken)this.input.get(0);
        int integer = token.intValue();
        if (integer < 0) {
            if (integer < -(1 << rate - 1)) {
                throw new IllegalActionException((Nameable)this, "integer is out of range.");
            }
            bits[0] = new BooleanToken(true);
            integer = (1 << rate - 1) + integer;
        } else {
            if (integer > (1 << rate - 1) - 1) {
                throw new IllegalActionException((Nameable)this, "integer is out of range.");
            }
            bits[0] = new BooleanToken(false);
        }
        int i = rate - 1;
        while (i > 0) {
            int remainder = integer % 2;
            integer /= 2;
            bits[i] = remainder == 0 ? new BooleanToken(false) : new BooleanToken(true);
            --i;
        }
        this.output.send(0, (Token[])bits, bits.length);
    }
}

