/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MatrixType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.graph.CPO;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class DotProduct
extends TypedAtomicActor {
    public TypedIOPort input1 = new TypedIOPort((ComponentEntity)this, "input1", true, false);
    public TypedIOPort input2 = new TypedIOPort((ComponentEntity)this, "input2", true, false);
    public TypedIOPort output = new TypedIOPort((ComponentEntity)this, "output", false, true);

    public DotProduct(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeAtLeast((InequalityTerm)new PortFunction(this.input1, this.input2));
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        DotProduct newObject = (DotProduct)((Object)super.clone(workspace));
        PortFunction function = new PortFunction(newObject.input1, newObject.input2);
        newObject.output.setTypeAtLeast((InequalityTerm)function);
        return newObject;
    }

    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input1.getType() instanceof ArrayType && this.input2.getType() instanceof ArrayType) {
            this._arrayFire();
        } else if (this.input1.getType() instanceof MatrixType && this.input2.getType() instanceof MatrixType) {
            this._matrixFire();
        } else {
            throw new IllegalActionException("Invalid types");
        }
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.input1.hasToken(0) || !this.input2.hasToken(0)) {
            if (this._debugging) {
                this._debug("Called prefire(), which returns false.");
            }
            return false;
        }
        return super.prefire();
    }

    private void _arrayFire() throws IllegalActionException {
        Token[] array2;
        ArrayToken token1 = (ArrayToken)this.input1.get(0);
        ArrayToken token2 = (ArrayToken)this.input2.get(0);
        Token[] array1 = token1.arrayValue();
        if (array1.length != (array2 = token2.arrayValue()).length) {
            throw new IllegalActionException("Inputs to DotProduct have unequal lengths: " + array1.length + " and " + array2.length + ".");
        }
        if (array1.length < 1) {
            throw new IllegalActionException("Inputs to DotProduct have no elements.");
        }
        Object dotProd = null;
        int i = 0;
        while (i < array1.length) {
            ScalarToken currentTerm = (ScalarToken)array1[i].multiply(array2[i]);
            dotProd = dotProd == null ? currentTerm : dotProd.add((Token)currentTerm);
            ++i;
        }
        this.output.broadcast(dotProd);
    }

    private void _matrixFire() throws IllegalActionException {
        Token sum;
        MatrixToken token1 = (MatrixToken)this.input1.get(0);
        MatrixToken token2 = (MatrixToken)this.input2.get(0);
        int columnCount1 = token1.getColumnCount();
        int rowCount1 = token1.getRowCount();
        int columnCount2 = token2.getColumnCount();
        int rowCount2 = token2.getRowCount();
        if (columnCount1 == columnCount2 && rowCount1 == rowCount2) {
            sum = token1.getElementAsToken(0, 0).zero();
            int i = 0;
            while (i < rowCount1) {
                int j = 0;
                while (j < columnCount1) {
                    Token element1 = token1.getElementAsToken(i, j);
                    Token element2 = token2.getElementAsToken(i, j);
                    sum = sum.add(element1.multiply(element2));
                    ++j;
                }
                ++i;
            }
        } else {
            String matrix1 = String.valueOf(rowCount1) + " by " + columnCount1;
            String matrix2 = String.valueOf(rowCount2) + " by " + columnCount2;
            throw new IllegalActionException("Tried to multiply a " + matrix1 + " matrix with a " + matrix2 + " matrix");
        }
        this.output.send(0, sum);
    }

    private static class PortFunction
    extends MonotonicFunction {
        private TypedIOPort _port1;
        private TypedIOPort _port2;

        private PortFunction(TypedIOPort port1, TypedIOPort port2) {
            this._port1 = port1;
            this._port2 = port2;
        }

        public Object getValue() {
            Type type1 = this._port1.getType();
            Type type2 = this._port2.getType();
            if (type1 == BaseType.UNKNOWN || type2 == BaseType.UNKNOWN) {
                return BaseType.UNKNOWN;
            }
            if (type1 instanceof ArrayType && type2 instanceof ArrayType) {
                Type elType1 = ((ArrayType)type1).getElementType();
                Type elType2 = ((ArrayType)type2).getElementType();
                CPO lattice = TypeLattice.lattice();
                return lattice.leastUpperBound((Object)elType1, (Object)elType2);
            }
            if (type1 instanceof MatrixType && type2 instanceof MatrixType) {
                Type elType1 = ((MatrixType)type1).getElementType();
                Type elType2 = ((MatrixType)type2).getElementType();
                CPO lattice = TypeLattice.lattice();
                return lattice.leastUpperBound((Object)elType1, (Object)elType2);
            }
            return BaseType.UNKNOWN;
        }

        public InequalityTerm[] getVariables() {
            InequalityTerm term1 = this._port1.getTypeTerm();
            InequalityTerm term2 = this._port2.getTypeTerm();
            if (term1.isSettable() && term2.isSettable()) {
                InequalityTerm[] array = new InequalityTerm[]{term1, term2};
                return array;
            }
            if (term1.isSettable()) {
                InequalityTerm[] array = new InequalityTerm[]{term1};
                return array;
            }
            if (term2.isSettable()) {
                InequalityTerm[] array = new InequalityTerm[]{term2};
                return array;
            }
            return new InequalityTerm[0];
        }
    }
}

