/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class ThresholdMonitor
extends TypedAtomicActor
implements CTStepSizeControlActor {
    public TypedIOPort input = new TypedIOPort((ComponentEntity)this, "input", true, false);
    public TypedIOPort output;
    public Parameter thresholdWidth;
    public Parameter thresholdCenter;
    private double _thWidth;
    private double _thCenter;
    private boolean _first;
    private boolean _accurate;
    private double _upperBound;
    private double _lowerBound;
    private double _lastInput;
    private double _thisInput;

    public ThresholdMonitor(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(false);
        this.input.setTypeEquals((Type)BaseType.DOUBLE);
        new Parameter((NamedObj)this.input, "signalType", (Token)new StringToken("CONTINUOUS"));
        this.output = new TypedIOPort((ComponentEntity)this, "output", false, true);
        this.output.setMultiport(false);
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
        new Parameter((NamedObj)this.output, "signalType", (Token)new StringToken("DISCRETE"));
        this._thWidth = 0.01;
        this.thresholdWidth = new Parameter((NamedObj)this, "thresholdWidth", (Token)new DoubleToken(this._thWidth));
        this._thCenter = 0.0;
        this.thresholdCenter = new Parameter((NamedObj)this, "thresholdCenter", (Token)new DoubleToken(this._thCenter));
        this._lowerBound = -0.005;
        this._upperBound = 0.005;
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.thresholdCenter || attribute == this.thresholdWidth) {
            this._thCenter = ((DoubleToken)this.thresholdCenter.getToken()).doubleValue();
            this._thWidth = Math.abs(((DoubleToken)this.thresholdWidth.getToken()).doubleValue());
            this._lowerBound = this._thCenter - this._thWidth / 2.0;
            this._upperBound = this._thCenter + this._thWidth / 2.0;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this._debug("Monitor" + this.getFullName() + " fired.");
        this._thisInput = ((DoubleToken)this.input.get(0)).doubleValue();
        if (this._thisInput <= this._upperBound && this._thisInput >= this._lowerBound) {
            this.output.send(0, (Token)new BooleanToken(true));
        } else {
            this.output.send(0, (Token)new BooleanToken(false));
        }
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        this._first = true;
    }

    public boolean postfire() throws IllegalActionException {
        super.postfire();
        if (this.input.hasToken(0)) {
            this._thisInput = ((DoubleToken)this.input.get(0)).doubleValue();
        }
        if (this._thisInput <= this._upperBound && this._thisInput >= this._lowerBound) {
            this.output.send(0, (Token)new BooleanToken(true));
        } else {
            this.output.send(0, (Token)new BooleanToken(false));
        }
        this._lastInput = this._thisInput;
        this._first = false;
        return true;
    }

    public double predictedStepSize() {
        return Double.MAX_VALUE;
    }

    public double refinedStepSize() {
        CTDirector dir = (CTDirector)this.getDirector();
        if (!this._accurate) {
            return 0.5 * dir.getCurrentStepSize();
        }
        return dir.getCurrentStepSize();
    }

    public boolean isStateAccurate() {
        return true;
    }

    public boolean isOutputAccurate() {
        if (!this._first && (this._lastInput >= this._upperBound && this._thisInput <= this._lowerBound || this._lastInput <= this._lowerBound && this._thisInput >= this._upperBound)) {
            this._debug(String.valueOf(this.getFullName()) + "one step crosses the threshold" + "cutting the step size in half.");
            this._accurate = false;
            return false;
        }
        this._accurate = true;
        return true;
    }
}

