/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedActor;
import ptolemy.actor.util.Time;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.domains.ct.kernel.CTCompositeActor;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTEmbeddedDirector;
import ptolemy.domains.ct.kernel.CTExecutionPhase;
import ptolemy.domains.ct.kernel.CTGeneralDirector;
import ptolemy.domains.ct.kernel.CTReceiver;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.domains.ct.kernel.CTTransparentDirector;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.FSMDirector;
import ptolemy.domains.fsm.kernel.ParseTreeEvaluatorForGuardExpression;
import ptolemy.domains.fsm.kernel.RelationList;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class HSFSMDirector
extends FSMDirector
implements CTTransparentDirector {
    private double _distanceToBoundary = 0.0;
    private double _lastDistanceToBoundary = 0.0;
    private boolean _outputAccurate = true;
    private boolean _transitionHasEvent = false;

    public HSFSMDirector() {
    }

    public HSFSMDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public HSFSMDirector(Workspace workspace) {
        super(workspace);
    }

    public void emitCurrentStates() throws IllegalActionException {
        for (Actor actor : this._enabledRefinements) {
            if (!(actor instanceof CTCompositeActor)) continue;
            ((CTCompositeActor)actor).emitCurrentStates();
        }
    }

    public void fire() throws IllegalActionException {
        if (this._debugging) {
            this._debug(this.getName(), " fire.");
        }
        FSMActor ctrl = this.getController();
        State currentState = ctrl.currentState();
        ctrl.readInputs();
        if (this._enabledTransition == null) {
            Transition transition;
            if (this.getExecutionPhase() == CTExecutionPhase.GENERATING_EVENTS_PHASE || this.getExecutionPhase() == CTExecutionPhase.ITERATING_PURELY_DISCRETE_ACTORS_PHASE) {
                transition = ctrl.chooseTransition(currentState.preemptiveTransitionList());
                this._transitionHasEvent = false;
            } else {
                transition = null;
            }
            if (transition != null) {
                this._enabledTransition = transition;
                this._mutationEnabled = false;
                TypedActor[] actors = transition.getRefinement();
                if (actors != null && actors.length > 0) {
                    int i = 0;
                    while (i < actors.length) {
                        if (this._stopRequested) break;
                        if (actors[i].prefire()) {
                            actors[i].fire();
                            actors[i].postfire();
                        }
                        ++i;
                    }
                    ctrl.readOutputsFromRefinement();
                }
                return;
            }
            boolean visited = currentState.isVisited();
            for (Actor actor : this._enabledRefinements) {
                Director director;
                if (this._debugging && this._verbose) {
                    this._debug(this.getName(), " fire refinement", ((NamedObj)actor).getName());
                }
                if (!visited && (director = actor.getDirector()) instanceof CTEmbeddedDirector) {
                    ((CTEmbeddedDirector)director).setInitialStatesNotReady();
                }
                actor.fire();
            }
            ctrl.readOutputsFromRefinement();
            if (!visited) {
                currentState.setVisited(true);
            }
            if (this.getExecutionPhase() == CTExecutionPhase.GENERATING_EVENTS_PHASE || this.getExecutionPhase() == CTExecutionPhase.ITERATING_PURELY_DISCRETE_ACTORS_PHASE) {
                transition = ctrl.chooseTransition(currentState.nonpreemptiveTransitionList());
                this._transitionHasEvent = false;
            } else {
                transition = null;
            }
            if (transition != null) {
                this._enabledTransition = transition;
                this._mutationEnabled = false;
                TypedActor[] transitionActors = transition.getRefinement();
                if (transitionActors != null && transitionActors.length > 0) {
                    int i = 0;
                    while (i < transitionActors.length) {
                        if (this._stopRequested) break;
                        if (transitionActors[i].prefire()) {
                            if (this._debugging) {
                                this._debug(this.getFullName(), " fire transition refinement", ((NamedObj)transitionActors[i]).getName());
                            }
                            transitionActors[i].fire();
                            transitionActors[i].postfire();
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public double getCurrentStepSize() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.getCurrentStepSize();
        }
        throw new InternalErrorException("A modal model with an HSFSMDirector must be used inside a CT model.");
    }

    public final double getErrorTolerance() {
        CompositeActor container = (CompositeActor)this.getContainer();
        Director executiveDirector = container.getExecutiveDirector();
        if (executiveDirector instanceof CTGeneralDirector) {
            return ((CTGeneralDirector)executiveDirector).getErrorTolerance();
        }
        throw new InternalErrorException("A modal model with an HSFSMDirector must be used inside a CT model.");
    }

    public CTGeneralDirector getExecutiveCTGeneralDirector() {
        CompositeActor container = (CompositeActor)this.getContainer();
        Director executiveDirector = container.getExecutiveDirector();
        if (executiveDirector instanceof CTGeneralDirector) {
            return (CTGeneralDirector)executiveDirector;
        }
        return null;
    }

    public CTExecutionPhase getExecutionPhase() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.getExecutionPhase();
        }
        return CTExecutionPhase.ITERATING_PURELY_DISCRETE_ACTORS_PHASE;
    }

    public Time getIterationBeginTime() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.getIterationBeginTime();
        }
        throw new InternalErrorException("A modal model with an HSFSMDirector must be used inside a CT model.");
    }

    public Time getModelTime() {
        CompositeActor cont = (CompositeActor)this.getContainer();
        Director execDir = cont.getExecutiveDirector();
        if (execDir != null) {
            return execDir.getModelTime();
        }
        return super.getModelTime();
    }

    public ParseTreeEvaluator getParseTreeEvaluator() {
        RelationList relationList = new RelationList();
        ParseTreeEvaluatorForGuardExpression evaluator = new ParseTreeEvaluatorForGuardExpression(relationList, this.getErrorTolerance());
        evaluator.setConstructionMode();
        return evaluator;
    }

    public void goToMarkedState() throws IllegalActionException {
        for (Actor actor : this._enabledRefinements) {
            if (!(actor instanceof CTCompositeActor)) continue;
            ((CTCompositeActor)actor).goToMarkedState();
        }
    }

    public String getODESolverClassName() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.getODESolverClassName();
        }
        return null;
    }

    public boolean hasCurrentEvent() {
        boolean eventPresent = false;
        Iterator actors = this._enabledRefinements.iterator();
        while (!eventPresent && actors.hasNext()) {
            Actor actor = (Actor)actors.next();
            if (!(actor instanceof CTCompositeActor)) continue;
            eventPresent |= ((CTCompositeActor)actor).hasCurrentEvent();
        }
        return this._transitionHasEvent || eventPresent;
    }

    public void initialize() throws IllegalActionException {
        super.initialize();
        FSMActor ctrl = this.getController();
        State currentState = ctrl.currentState();
        this._enabledRefinements = new LinkedList();
        TypedActor[] actors = currentState.getRefinement();
        if (actors != null) {
            int i = 0;
            while (i < actors.length) {
                actors[i].initialize();
                this._enabledRefinements.add(actors[i]);
                ++i;
            }
        }
    }

    public boolean isDiscretePhase() {
        CTGeneralDirector executiveDirector = this.getExecutiveCTGeneralDirector();
        if (executiveDirector != null) {
            return executiveDirector.isDiscretePhase();
        }
        throw new InternalErrorException("A modal model with an HSFSMDirector must be used inside a CT model.");
    }

    public boolean isOutputAccurate() {
        boolean result = true;
        Actor container = (Actor)this.getContainer();
        CTDirector dir = (CTDirector)container.getExecutiveDirector();
        if (this._enabledRefinements != null) {
            for (Actor refinement : this._enabledRefinements) {
                if (!(refinement instanceof CTStepSizeControlActor)) continue;
                boolean bl = result = result && ((CTStepSizeControlActor)refinement).isOutputAccurate();
            }
        }
        try {
            Transition nonPreemptiveTrWithEvent;
            Transition preemptiveTrWithEvent;
            List nonpreemptiveEnabledTransitions;
            FSMActor ctrl = this.getController();
            State currentState = ctrl.currentState();
            List preemptiveEnabledTransitions = ctrl.enabledTransitions(currentState.preemptiveTransitionList());
            if (preemptiveEnabledTransitions.size() != 0 && this._debugging && this._verbose) {
                this._debug("Find enabled preemptive transitions.");
            }
            if ((nonpreemptiveEnabledTransitions = ctrl.enabledTransitions(currentState.nonpreemptiveTransitionList())).size() != 0 && this._debugging && this._verbose) {
                this._debug("Find enabled non-preemptive transitions.");
            }
            if ((preemptiveTrWithEvent = this._checkEvent(currentState.preemptiveTransitionList())) != null && this._debugging) {
                this._debug("Detected event for transition:  " + preemptiveTrWithEvent.getGuardExpression());
            }
            if ((nonPreemptiveTrWithEvent = this._checkEvent(currentState.nonpreemptiveTransitionList())) != null && this._debugging) {
                this._debug("Detected event for transition:  " + nonPreemptiveTrWithEvent.getGuardExpression());
            }
            double errorTolerance = dir.getErrorTolerance();
            if (preemptiveEnabledTransitions.size() == 0 && nonpreemptiveEnabledTransitions.size() == 0 && preemptiveTrWithEvent == null && nonPreemptiveTrWithEvent == null) {
                this._transitionHasEvent = false;
                this._lastDistanceToBoundary = 0.0;
                this._distanceToBoundary = 0.0;
                this._outputAccurate = true;
            } else {
                ParseTreeEvaluatorForGuardExpression parseTreeEvaluator;
                RelationList relationList;
                double distanceToBoundary;
                double distanceToBoundary2;
                RelationList relationList2;
                ParseTreeEvaluatorForGuardExpression parseTreeEvaluator2;
                Transition enabledTransition = null;
                this._distanceToBoundary = Double.MIN_VALUE;
                for (Transition transition : preemptiveEnabledTransitions) {
                    parseTreeEvaluator2 = (ParseTreeEvaluatorForGuardExpression)transition.getParseTreeEvaluator();
                    relationList2 = parseTreeEvaluator2.getRelationList();
                    distanceToBoundary2 = relationList2.getMaximumDifference();
                    if (!(distanceToBoundary2 > this._distanceToBoundary)) continue;
                    this._distanceToBoundary = distanceToBoundary2;
                    this._lastDistanceToBoundary = relationList2.getPreviousMaximumDistance();
                    enabledTransition = transition;
                }
                for (Transition transition : nonpreemptiveEnabledTransitions) {
                    parseTreeEvaluator2 = (ParseTreeEvaluatorForGuardExpression)transition.getParseTreeEvaluator();
                    relationList2 = parseTreeEvaluator2.getRelationList();
                    distanceToBoundary2 = relationList2.getMaximumDifference();
                    if (!(distanceToBoundary2 > this._distanceToBoundary)) continue;
                    this._distanceToBoundary = distanceToBoundary2;
                    this._lastDistanceToBoundary = relationList2.getPreviousMaximumDistance();
                    enabledTransition = transition;
                }
                if (preemptiveTrWithEvent != null && (distanceToBoundary = (relationList = (parseTreeEvaluator = (ParseTreeEvaluatorForGuardExpression)preemptiveTrWithEvent.getParseTreeEvaluator()).getRelationList()).getMaximumDifference()) > this._distanceToBoundary) {
                    this._distanceToBoundary = distanceToBoundary;
                    this._lastDistanceToBoundary = relationList.getPreviousMaximumDistance();
                    enabledTransition = preemptiveTrWithEvent;
                }
                if (nonPreemptiveTrWithEvent != null && (distanceToBoundary = (relationList = (parseTreeEvaluator = (ParseTreeEvaluatorForGuardExpression)nonPreemptiveTrWithEvent.getParseTreeEvaluator()).getRelationList()).getMaximumDifference()) > this._distanceToBoundary) {
                    this._distanceToBoundary = distanceToBoundary;
                    this._lastDistanceToBoundary = relationList.getPreviousMaximumDistance();
                    enabledTransition = nonPreemptiveTrWithEvent;
                }
                if (this._debugging && this._verbose) {
                    this._debug("The guard " + enabledTransition.getGuardExpression() + " has the biggest difference to boundary as " + this._distanceToBoundary);
                }
                this._outputAccurate = this._distanceToBoundary < errorTolerance;
                this._transitionHasEvent = this._outputAccurate;
            }
            return result && this._outputAccurate;
        }
        catch (Throwable throwable) {
            throw new InternalErrorException(throwable);
        }
    }

    public boolean isStateAccurate() {
        boolean result = true;
        if (this._enabledRefinements != null) {
            for (Actor refinement : this._enabledRefinements) {
                if (!(refinement instanceof CTStepSizeControlActor)) continue;
                boolean bl = result = result && ((CTStepSizeControlActor)refinement).isStateAccurate();
            }
        }
        return result;
    }

    public void markState() {
        for (Actor actor : this._enabledRefinements) {
            if (!(actor instanceof CTCompositeActor)) continue;
            ((CTCompositeActor)actor).markState();
        }
    }

    public Receiver newReceiver() {
        CTReceiver receiver = new CTReceiver();
        receiver.setSignalType(CTReceiver.DISCRETE);
        return receiver;
    }

    public boolean postfire() throws IllegalActionException {
        Transition transition;
        ListIterator iterator;
        boolean postfireReturns = true;
        FSMActor ctrl = this.getController();
        State currentState = ctrl.currentState();
        CompositeActor container = (CompositeActor)this.getContainer();
        Director executiveDirector = container.getExecutiveDirector();
        for (Actor refinement : this._enabledRefinements) {
            postfireReturns = postfireReturns && refinement.postfire();
            for (IOPort p : refinement.outputPortList()) {
                this.transferOutputs(p);
            }
        }
        Transition tr = this._enabledTransition;
        if (tr != null) {
            RelationList relationList;
            ParseTreeEvaluatorForGuardExpression parseTreeEvaluator;
            if (this._debugging) {
                this._debug("Postfire deals with enabled transition " + tr.getGuardExpression());
            }
            iterator = currentState.nonpreemptiveTransitionList().listIterator();
            while (iterator.hasNext()) {
                transition = (Transition)((Object)iterator.next());
                parseTreeEvaluator = (ParseTreeEvaluatorForGuardExpression)transition.getParseTreeEvaluator();
                relationList = parseTreeEvaluator.getRelationList();
                relationList.resetRelationList();
            }
            iterator = currentState.preemptiveTransitionList().listIterator();
            while (iterator.hasNext()) {
                transition = (Transition)((Object)iterator.next());
                parseTreeEvaluator = (ParseTreeEvaluatorForGuardExpression)transition.getParseTreeEvaluator();
                relationList = parseTreeEvaluator.getRelationList();
                relationList.resetRelationList();
            }
            if (executiveDirector != null) {
                if (this._debugging) {
                    this._debug(String.valueOf(executiveDirector.getFullName()) + " requests refiring at " + this.getModelTime());
                }
                executiveDirector.fireAt((Actor)container, this.getModelTime());
            }
            if (this.getExecutionPhase() == CTExecutionPhase.UPDATING_CONTINUOUS_STATES_PHASE || executiveDirector == null) {
                this._enabledTransition = null;
                this._mutationEnabled = true;
            }
        } else if (this.getExecutionPhase() == CTExecutionPhase.GENERATING_EVENTS_PHASE || this.getExecutionPhase() == CTExecutionPhase.POSTFIRING_EVENT_GENERATORS_PHASE) {
            RelationList relationList;
            ParseTreeEvaluatorForGuardExpression parseTreeEvaluator;
            iterator = currentState.nonpreemptiveTransitionList().listIterator();
            while (iterator.hasNext()) {
                transition = (Transition)((Object)iterator.next());
                parseTreeEvaluator = (ParseTreeEvaluatorForGuardExpression)transition.getParseTreeEvaluator();
                relationList = parseTreeEvaluator.getRelationList();
                relationList.commitRelationValues();
            }
            iterator = currentState.preemptiveTransitionList().listIterator();
            while (iterator.hasNext()) {
                transition = (Transition)((Object)iterator.next());
                parseTreeEvaluator = (ParseTreeEvaluatorForGuardExpression)transition.getParseTreeEvaluator();
                relationList = parseTreeEvaluator.getRelationList();
                relationList.commitRelationValues();
            }
        }
        postfireReturns = postfireReturns && super.postfire();
        return postfireReturns;
    }

    public double predictedStepSize() {
        double result = Double.MAX_VALUE;
        if (this._enabledRefinements != null) {
            for (Actor refinement : this._enabledRefinements) {
                if (!(refinement instanceof CTStepSizeControlActor)) continue;
                result = Math.min(result, ((CTStepSizeControlActor)refinement).predictedStepSize());
            }
        }
        return result;
    }

    public boolean prefire() throws IllegalActionException {
        FSMActor ctrl = this.getController();
        State currentState = ctrl.currentState();
        if (this._debugging) {
            this._debug(this.getName(), " find FSMActor " + ctrl.getName() + " and the current state is " + currentState.getName());
        }
        TypedActor[] actors = currentState.getRefinement();
        this._enabledRefinements = new LinkedList();
        if (actors != null) {
            int i = 0;
            while (i < actors.length) {
                this._enabledRefinements.add(actors[i]);
                actors[i].prefire();
                ++i;
            }
        }
        this._outputAccurate = true;
        return super.prefire();
    }

    public boolean prefireDynamicActors() throws IllegalActionException {
        boolean result = true;
        if (this._enabledRefinements != null) {
            for (Actor refinement : this._enabledRefinements) {
                if (!(refinement instanceof CTCompositeActor)) continue;
                boolean bl = result = result && ((CTCompositeActor)refinement).prefireDynamicActors();
            }
        }
        return result;
    }

    public double refinedStepSize() {
        CTDirector director = (CTDirector)((Actor)this.getContainer()).getExecutiveDirector();
        double result = director.getCurrentStepSize();
        if (this._enabledRefinements != null) {
            for (Actor refinement : this._enabledRefinements) {
                if (!(refinement instanceof CTStepSizeControlActor)) continue;
                result = Math.min(result, ((CTStepSizeControlActor)refinement).refinedStepSize());
            }
        }
        if (!this._outputAccurate) {
            double refinedStepSize = result;
            double errorTolerance = director.getErrorTolerance();
            double currentStepSize = director.getCurrentStepSize();
            refinedStepSize = currentStepSize * (this._lastDistanceToBoundary + errorTolerance / 2.0) / (this._lastDistanceToBoundary + this._distanceToBoundary);
            result = Math.min(result, refinedStepSize);
        }
        return result;
    }

    private Transition _checkEvent(List transitionList) {
        Transition result = null;
        Iterator transitionRelations = transitionList.iterator();
        while (transitionRelations.hasNext() && !this._stopRequested && result == null) {
            Transition transition = (Transition)((Object)transitionRelations.next());
            ParseTreeEvaluatorForGuardExpression parseTreeEvaluator = (ParseTreeEvaluatorForGuardExpression)transition.getParseTreeEvaluator();
            RelationList relationList = parseTreeEvaluator.getRelationList();
            if (!relationList.hasEvent()) continue;
            result = transition;
        }
        return result;
    }
}

