/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.string;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class StringCompare
extends TypedAtomicActor {
    public Parameter function = new Parameter((NamedObj)this, "function");
    public PortParameter firstString;
    public Parameter ignoreCase;
    public TypedIOPort output;
    public PortParameter secondString;
    private int _function;
    private static final int _EQUALS = 0;
    private static final int _STARTSWITH = 1;
    private static final int _ENDSWITH = 2;
    private static final int _CONTAINS = 3;

    public StringCompare(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.function.setStringMode(true);
        this.function.setExpression("equals");
        this.function.addChoice("equals");
        this.function.addChoice("startsWith");
        this.function.addChoice("endsWith");
        this.function.addChoice("contains");
        this._function = 0;
        this.ignoreCase = new Parameter((NamedObj)this, "ignoreCase");
        this.ignoreCase.setTypeEquals((Type)BaseType.BOOLEAN);
        this.ignoreCase.setToken((Token)new BooleanToken(false));
        this.firstString = new PortParameter((NamedObj)this, "firstString");
        this.firstString.setExpression("");
        this.firstString.setStringMode(true);
        this.secondString = new PortParameter((NamedObj)this, "secondString");
        this.secondString.setExpression("");
        this.secondString.setStringMode(true);
        this.output = new TypedIOPort((ComponentEntity)this, "output");
        this.output.setOutput(true);
        this.output.setTypeEquals((Type)BaseType.BOOLEAN);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-15\" width=\"60\" height=\"30\" style=\"fill:white\"/>\n</svg>\n");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.function) {
            String functionName = ((StringToken)this.function.getToken()).stringValue();
            if (functionName.equals("equals")) {
                this._function = 0;
                return;
            } else if (functionName.equals("startsWith")) {
                this._function = 1;
                return;
            } else if (functionName.equals("endsWith")) {
                this._function = 2;
                return;
            } else {
                if (!functionName.equals("contains")) throw new IllegalActionException((Nameable)this, "Unrecognized string function: " + functionName);
                this._function = 3;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void fire() throws IllegalActionException {
        super.fire();
        this.firstString.update();
        this.secondString.update();
        String input1 = ((StringToken)this.firstString.getToken()).stringValue();
        String input2 = ((StringToken)this.secondString.getToken()).stringValue();
        if (((BooleanToken)this.ignoreCase.getToken()).booleanValue()) {
            input1 = input1.toLowerCase();
            input2 = input2.toLowerCase();
        }
        this.output.send(0, (Token)new BooleanToken(this._doFunction(input1, input2)));
    }

    private boolean _doFunction(String input1, String input2) {
        boolean result;
        switch (this._function) {
            case 0: {
                result = input1.equals(input2);
                break;
            }
            case 1: {
                result = input1.startsWith(input2);
                break;
            }
            case 2: {
                result = input1.endsWith(input2);
                break;
            }
            case 3: {
                result = input1.indexOf(input2) >= 0;
                break;
            }
            default: {
                throw new InternalErrorException("Invalid value for _function private variable. StringCompare actor (" + this.getFullName() + ")" + " on function type " + this._function);
            }
        }
        return result;
    }
}

