/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.Complex;

public class PolarToComplex
extends TypedAtomicActor {
    public TypedIOPort magnitude = new TypedIOPort((ComponentEntity)this, "magnitude", true, false);
    public TypedIOPort angle;
    public TypedIOPort output;

    public PolarToComplex(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.magnitude.setTypeEquals((Type)BaseType.DOUBLE);
        this.angle = new TypedIOPort((ComponentEntity)this, "angle", true, false);
        this.angle.setTypeEquals((Type)BaseType.DOUBLE);
        this.output = new TypedIOPort((ComponentEntity)this, "output", false, true);
        this.output.setTypeEquals((Type)BaseType.COMPLEX);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        double magnitudeValue = ((DoubleToken)this.magnitude.get(0)).doubleValue();
        double angleValue = ((DoubleToken)this.angle.get(0)).doubleValue();
        double xValue = magnitudeValue * Math.cos(angleValue);
        double yValue = magnitudeValue * Math.sin(angleValue);
        this.output.send(0, (Token)new ComplexToken(new Complex(xValue, yValue)));
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.magnitude.hasToken(0) || !this.angle.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

