/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class IntArrayToString
extends TypedAtomicActor {
    public TypedIOPort input = new TypedIOPort((ComponentEntity)this, "input", true, false);
    public TypedIOPort output;

    public IntArrayToString(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals((Type)new ArrayType((Type)BaseType.INT));
        this.output = new TypedIOPort((ComponentEntity)this, "output", false, true);
        this.output.setTypeEquals((Type)BaseType.STRING);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken dataIntArrayToken = (ArrayToken)this.input.get(0);
        byte[] dataBytes = new byte[dataIntArrayToken.length()];
        int j = 0;
        while (j < dataIntArrayToken.length()) {
            IntToken dataIntOneToken = (IntToken)dataIntArrayToken.getElement(j);
            dataBytes[j] = (byte)dataIntOneToken.intValue();
            ++j;
        }
        String outputValue = new String(dataBytes);
        this.output.send(0, (Token)new StringToken(outputValue));
    }

    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

