/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util.swing.calendar;

import com.isencia.util.swing.calendar.JCalendar;
import com.isencia.util.swing.calendar.TimeSelector;
import com.isencia.util.swing.layout.AbsoluteConstraints;
import com.isencia.util.swing.layout.AbsoluteLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class DateTimeSelector
extends JPanel
implements PropertyChangeListener {
    FocusManager previousFocusManager = null;
    private JCalendar calendarPanel;
    private JTextField txtDateField;
    private TimeSelector txtTimeField;
    private Calendar calendar;
    private Calendar oldCalendar;
    private JButton btnDateVisible;
    private SimpleDateFormat formatter;
    private JPopupMenu popup = null;

    public void init() {
        this.setLayout(new BorderLayout());
        this.calendarPanel = new JCalendar();
        this.txtTimeField = new TimeSelector();
        this.btnDateVisible = new JButton();
        this.txtDateField = new JTextField();
        this.txtDateField.setEditable(false);
        this.setLayout(new AbsoluteLayout());
        this.add((Component)this.txtTimeField, new AbsoluteConstraints(140, 0, 80, -1));
        this.btnDateVisible.setText("...");
        this.btnDateVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeSelector.this.setPanelVisibility(actionEvent);
            }
        });
        this.add((Component)this.btnDateVisible, new AbsoluteConstraints(110, 0, 30, 20));
        this.add((Component)this.txtDateField, new AbsoluteConstraints(0, 0, 110, 20));
        this.txtTimeField.addPropertyChangeListener(this);
        this.calendarPanel.addPropertyChangeListener(this);
        this.calendarPanel.setBorder(new LineBorder(Color.black));
        this.formatter = new SimpleDateFormat("dd MMM yyyy");
        this.popup = new JPopupMenu();
    }

    public SimpleDateFormat getDateFormatter() {
        return this.formatter;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public void setTimeFieldProperties(int n, int n2, int n3) {
        String string = this.txtTimeField.getTime();
        SimpleDateFormat simpleDateFormat = this.txtTimeField.getTimeFormatter();
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {}
        this.txtTimeField = new TimeSelector(n, n2, n3);
        this.txtTimeField.setTime(this.txtTimeField.getTimeFormatter().format(date));
        this.txtTimeField.addPropertyChangeListener(this);
    }

    private void setPanelVisibility(ActionEvent actionEvent) {
        this.oldCalendar = (Calendar)this.calendarPanel.getCalendar().clone();
        this.calendarPanel.setVisible(true);
        this.popup.add(this.calendarPanel);
        this.popup.show(this.txtDateField, 0, 25);
        this.previousFocusManager = FocusManager.getCurrentManager();
        FocusManager.setCurrentManager(null);
        this.calendarPanel.setSelectedDay();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("calendar")) {
            this.calendar = (Calendar)propertyChangeEvent.getNewValue();
            this.txtDateField.setText(this.formatter.format(this.calendar.getTime()));
        }
        if (propertyChangeEvent.getPropertyName().equals("closeMe")) {
            this.calendar = (Calendar)propertyChangeEvent.getNewValue();
            this.txtDateField.setText(this.formatter.format(this.calendar.getTime()));
            FocusManager.setCurrentManager(this.previousFocusManager);
            this.calendarPanel.setVisible(false);
            this.popup.setVisible(false);
        }
        if (propertyChangeEvent.getPropertyName().equals("escape")) {
            this.calendar = this.oldCalendar;
            this.txtDateField.setText(this.formatter.format(this.calendar.getTime()));
            this.calendarPanel.setCalendar(this.calendar);
            FocusManager.setCurrentManager(this.previousFocusManager);
            this.calendarPanel.setVisible(false);
            this.popup.setVisible(false);
        }
    }

    public String getTimeAsString() {
        return this.txtTimeField.getTime();
    }

    public String getDateAsString() {
        return this.txtDateField.getText();
    }

    public String getDateTimeAsString() {
        return String.valueOf(this.getDateAsString()) + " " + this.getTimeAsString();
    }

    public void setDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.calendarPanel.setCalendar(calendar);
        String string = this.txtTimeField.getTimeFormatter().format(date);
        this.txtTimeField.setTime(string);
    }

    public static void main(String[] stringArray) {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        try {
            JFrame jFrame = new JFrame("JCalendar Demo");
            jFrame.addWindowListener(windowAdapter);
            DateTimeSelector dateTimeSelector = new DateTimeSelector();
            dateTimeSelector.init();
            String string = "02/02/2002";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date date = simpleDateFormat.parse(string);
            dateTimeSelector.setDate(date);
            jFrame.getContentPane().add(dateTimeSelector);
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (ParseException parseException) {}
    }
}

