/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.util;

import com.isencia.util.BlockingQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.IQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingReaderQueue
extends BlockingQueue {
    private static final Logger logger = LoggerFactory.getLogger(BlockingReaderQueue.class);

    public BlockingReaderQueue(IQueue iQueue) {
        super(iQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Object object) {
        if (logger.isTraceEnabled()) {
            logger.trace("put() - entry - Putting :" + object);
        }
        boolean bl = false;
        IQueue iQueue = this.getQueue();
        synchronized (iQueue) {
            if (this.getQueue().size() == 0) {
                this.setNotified(true);
                this.getQueue().notifyAll();
            }
            bl = this.getQueue().put(object);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("put() - exit - Returning :" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() throws EmptyQueueException {
        if (logger.isTraceEnabled()) {
            logger.trace("get() - entry");
        }
        Object object = null;
        IQueue iQueue = this.getQueue();
        synchronized (iQueue) {
            this.setNotified(false);
            while (this.getQueue().size() == 0 && !this.isNotified()) {
                try {
                    this.getQueue().wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new EmptyQueueException("Interrupted");
                }
            }
            if (this.getQueue().size() <= 0) {
                throw new EmptyQueueException("Triggered");
            }
            object = this.getQueue().get();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("get() - exit - Returning :" + object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long l) throws EmptyQueueException {
        if (logger.isTraceEnabled()) {
            logger.trace("get() - entry - timeout :" + l);
        }
        Object object = null;
        IQueue iQueue = this.getQueue();
        synchronized (iQueue) {
            if (this.getQueue().size() == 0) {
                this.setNotified(false);
                long l2 = System.currentTimeMillis() + l;
                while (!this.isNotified()) {
                    long l3 = l2 - System.currentTimeMillis();
                    if (l3 <= 0L) break;
                    try {
                        this.getQueue().wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug("get() - queue interrupted");
                        throw new EmptyQueueException("Interrupted");
                    }
                }
            }
            if (this.getQueue().size() <= 0) {
                logger.debug("get() - queue triggered or interrupted");
                throw new EmptyQueueException("Triggered or Timeout");
            }
            object = this.getQueue().get();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("get() - exit - Returning :" + object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trigger() {
        if (logger.isTraceEnabled()) {
            logger.trace("trigger() - entry");
        }
        IQueue iQueue = this.getQueue();
        synchronized (iQueue) {
            if (this.getQueue().size() == 0) {
                this.setNotified(true);
                this.getQueue().notifyAll();
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("trigger() - exit");
        }
    }
}

