/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.properties;

import com.isencia.properties.IPropertyContainer;
import com.isencia.properties.PropertiesLoadingException;
import com.isencia.properties.XmlPropertyContainer;
import com.isencia.util.StringConvertor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyContainerFactory {
    private static final Logger logger = LoggerFactory.getLogger(PropertyContainerFactory.class);
    private static PropertyContainerFactory instance = null;
    private Map propCntsBySrcName = new HashMap();
    private Map propCntsByCntName = new HashMap();
    private String propsHome = null;

    public PropertyContainerFactory() {
        String string = System.getProperty("be.isencia.home");
        String string2 = System.getProperty("be.isencia.config");
        if (string == null || string.length() == 0) {
            string = ".";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "conf";
        }
        this.propsHome = String.valueOf(string) + File.separatorChar + string2 + File.separatorChar;
    }

    public IPropertyContainer get(String string) {
        IPropertyContainer iPropertyContainer = (IPropertyContainer)this.propCntsByCntName.get(string);
        return iPropertyContainer;
    }

    public static PropertyContainerFactory instance() {
        if (instance == null) {
            instance = new PropertyContainerFactory();
        }
        return instance;
    }

    public IPropertyContainer registerPropertySource(String string) throws PropertiesLoadingException {
        IPropertyContainer iPropertyContainer;
        if (logger.isTraceEnabled()) {
            logger.trace("registerPropertySource() - entry - name :" + string);
        }
        String string2 = String.valueOf(this.propsHome) + string;
        string2 = StringConvertor.convertPathDelimiters(string2);
        if (this.propCntsBySrcName.containsKey(string)) {
            iPropertyContainer = (IPropertyContainer)this.propCntsBySrcName.get(string);
            this.propCntsBySrcName.remove(string);
            this.propCntsByCntName.remove(iPropertyContainer.getName());
        }
        iPropertyContainer = new XmlPropertyContainer();
        try {
            FileReader fileReader = new FileReader(string2);
            iPropertyContainer.loadProperties(fileReader);
            iPropertyContainer.setSourceName(string2);
            ((Reader)fileReader).close();
            if (logger.isDebugEnabled()) {
                logger.debug("registerPropertySource() - loaded properties :" + iPropertyContainer);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PropertiesLoadingException("Property file " + string2 + " not found");
        }
        catch (IOException iOException) {
            throw new PropertiesLoadingException("Property file " + string2 + " could not be read");
        }
        this.propCntsBySrcName.put(string, iPropertyContainer);
        this.propCntsByCntName.put(iPropertyContainer.getName(), iPropertyContainer);
        if (logger.isTraceEnabled()) {
            logger.trace("registerPropertySource() - exit");
        }
        return iPropertyContainer;
    }
}

