/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.SingleElementCollector;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.CompositeQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IFilterAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class AbstractPublisherAction
implements IPublisherAction {
    public static final String CONFIG_ANY = "ANY";
    public static final String CONFIG_SEGMENT_SEPARATOR = ".";
    protected IPublisherInfo info;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] parseConfigSpec(String configSpec) {
        String[] result = AbstractPublisherAction.getArrayFromString(configSpec, CONFIG_SEGMENT_SEPARATOR);
        int i = 0;
        while (i < result.length) {
            if (result[i].equals("*")) {
                result[i] = CONFIG_ANY;
            }
            ++i;
        }
        if (result.length < 3) {
            String[] temp = new String[3];
            System.arraycopy(result, 0, temp, 0, result.length);
            int i2 = result.length;
            while (i2 < temp.length) {
                temp[i2] = CONFIG_ANY;
                ++i2;
            }
            result = temp;
        }
        return result;
    }

    public static String createConfigSpec(String ws, String os, String arch) {
        return String.valueOf(ws) + '.' + os + '.' + arch;
    }

    protected void addSelfCapability(MetadataFactory.InstallableUnitDescription root) {
        root.setCapabilities(new IProvidedCapability[]{this.createSelfCapability(root.getId(), root.getVersion())});
    }

    protected String createFilterSpec(String configSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        if (config[0] != null || config[1] != null || config[2] != null) {
            String filterArch;
            String filterWs = config[0] != null && config[0] != CONFIG_ANY ? "(osgi.ws=" + config[0] + ")" : "";
            String filterOs = config[1] != null && config[1] != CONFIG_ANY ? "(osgi.os=" + config[1] + ")" : "";
            String string = filterArch = config[2] != null && config[2] != CONFIG_ANY ? "(osgi.arch=" + config[2] + ")" : "";
            if (filterWs.length() == 0 && filterOs.length() == 0 && filterArch.length() == 0) {
                return null;
            }
            return "(& " + filterWs + filterOs + filterArch + ")";
        }
        return null;
    }

    protected boolean filterMatches(String filter, String configSpec) {
        if (filter == null) {
            return true;
        }
        Filter ldapFilter = null;
        try {
            ldapFilter = Activator.context.createFilter(filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return true;
        }
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        Hashtable<String, String> environment = new Hashtable<String, String>(3);
        ((Dictionary)environment).put("osgi.ws", config[0]);
        ((Dictionary)environment).put("osgi.os", config[1]);
        ((Dictionary)environment).put("osgi.arch", config[2]);
        return ldapFilter.match(environment);
    }

    protected String createIdString(String configSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        return String.valueOf(config[0]) + '.' + config[1] + '.' + config[2];
    }

    protected String createCUIdString(String id, String type, String flavor, String configSpec) {
        return String.valueOf(flavor) + id + CONFIG_SEGMENT_SEPARATOR + type + CONFIG_SEGMENT_SEPARATOR + this.createIdString(configSpec);
    }

    protected Collection createIURequirements(Collection children) {
        ArrayList<IRequiredCapability> result = new ArrayList<IRequiredCapability>(children.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof IInstallableUnit) {
                IInstallableUnit iu = (IInstallableUnit)next;
                VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
                result.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (String)iu.getFilter(), (boolean)false, (boolean)false));
                continue;
            }
            if (!(next instanceof VersionedName)) continue;
            VersionedName name = (VersionedName)next;
            Version version = name.getVersion();
            VersionRange range = version == null || Version.emptyVersion.equals((Object)version) ? VersionRange.emptyRange : new VersionRange(version, true, version, true);
            String filter = this.getFilterAdvice(name);
            result.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)name.getId(), (VersionRange)range, (String)filter, (boolean)false, (boolean)false));
        }
        return result;
    }

    private String getFilterAdvice(VersionedName name) {
        if (this.info == null) {
            return null;
        }
        String string = name.getId();
        Version version = name.getVersion();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IFilterAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection filterAdvice = this.info.getAdvice(CONFIG_ANY, true, string, version, clazz);
        Iterator i = filterAdvice.iterator();
        while (i.hasNext()) {
            IFilterAdvice advice = (IFilterAdvice)i.next();
            String result = advice.getFilter(name.getId(), name.getVersion(), false);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected MetadataFactory.InstallableUnitDescription createIUShell(String id, Version version) {
        MetadataFactory.InstallableUnitDescription root = new MetadataFactory.InstallableUnitDescription();
        root.setId(id);
        root.setVersion(version);
        return root;
    }

    protected IArtifactDescriptor createPack200ArtifactDescriptor(IArtifactKey key, File pathOnDisk, String installSize) {
        ArtifactDescriptor result = new ArtifactDescriptor(key);
        if (pathOnDisk != null) {
            result.setProperty("artifact.size", installSize);
            result.setProperty("download.size", Long.toString(pathOnDisk.length()));
        }
        ProcessingStepDescriptor[] steps = new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
        result.setProcessingSteps(steps);
        result.setProperty("format", "packed");
        return result;
    }

    protected MetadataFactory.InstallableUnitDescription createParentIU(Collection children, String id, Version version) {
        MetadataFactory.InstallableUnitDescription root = this.createIUShell(id, version);
        root.addRequiredCapabilities(this.createIURequirements(children));
        this.addSelfCapability(root);
        return root;
    }

    protected FileUtils.IPathComputer createParentPrefixComputer(int segmentsToKeep) {
        return FileUtils.createParentPrefixComputer((int)segmentsToKeep);
    }

    protected FileUtils.IPathComputer createRootPrefixComputer(File root) {
        return FileUtils.createRootPathComputer((File)root);
    }

    protected IProvidedCapability createSelfCapability(String installableUnitId, Version installableUnitVersion) {
        return MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)installableUnitId, (Version)installableUnitVersion);
    }

    protected static MetadataFactory.InstallableUnitDescription[] processAdditionalInstallableUnitsAdvice(IInstallableUnit iu, IPublisherInfo publisherInfo) {
        Collection advice;
        String string = iu.getId();
        Version version = iu.getVersion();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((advice = publisherInfo.getAdvice(null, false, string, version, clazz)).isEmpty()) {
            return null;
        }
        ArrayList<MetadataFactory.InstallableUnitDescription> ius = new ArrayList<MetadataFactory.InstallableUnitDescription>();
        Iterator iterator = advice.iterator();
        while (iterator.hasNext()) {
            IAdditionalInstallableUnitAdvice entry = (IAdditionalInstallableUnitAdvice)iterator.next();
            MetadataFactory.InstallableUnitDescription[] others = entry.getAdditionalInstallableUnitDescriptions(iu);
            if (others == null) continue;
            ius.addAll(Arrays.asList(others));
        }
        return ius.toArray(new MetadataFactory.InstallableUnitDescription[ius.size()]);
    }

    protected static void processArtifactPropertiesAdvice(IInstallableUnit iu, ArtifactDescriptor descriptor, IPublisherInfo info) {
        String string = iu.getId();
        Version version = iu.getVersion();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, string, version, clazz);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IPropertyAdvice entry = (IPropertyAdvice)i.next();
            Properties props = entry.getArtifactProperties(iu, (IArtifactDescriptor)descriptor);
            if (props == null) continue;
            Iterator<Object> j = props.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                descriptor.setRepositoryProperty(key, props.getProperty(key));
            }
        }
    }

    protected static void processInstallableUnitPropertiesAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo info) {
        String string = iu.getId();
        Version version = iu.getVersion();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, string, version, clazz);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IPropertyAdvice entry = (IPropertyAdvice)i.next();
            Properties props = entry.getInstallableUnitProperties(iu);
            if (props == null) continue;
            Iterator<Object> j = props.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                iu.setProperty(key, props.getProperty(key));
            }
        }
    }

    protected static void processCapabilityAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo info) {
        Collection advice;
        String string = iu.getId();
        Version version = iu.getVersion();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((advice = info.getAdvice(null, false, string, version, clazz)).isEmpty()) {
            return;
        }
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IProvidedCapability[] providedAdvice;
            IRequiredCapability[] metaRequiredAdvice;
            ICapabilityAdvice entry = (ICapabilityAdvice)i.next();
            IRequiredCapability[] requiredAdvice = entry.getRequiredCapabilities(iu);
            if (requiredAdvice != null) {
                IRequiredCapability[] current = iu.getRequiredCapabilities();
                HashSet<IRequiredCapability> resultRequiredCapabilities = new HashSet<IRequiredCapability>(Arrays.asList(current));
                int j = 0;
                while (j < current.length) {
                    IRequiredCapability currentRequiredCapability = current[j];
                    int k = 0;
                    while (k < requiredAdvice.length) {
                        IRequiredCapability requiredCapability = requiredAdvice[k];
                        if (requiredCapability.getNamespace().equals(currentRequiredCapability.getNamespace()) && requiredCapability.getName().equals(currentRequiredCapability.getName())) {
                            resultRequiredCapabilities.remove(currentRequiredCapability);
                            break;
                        }
                        ++k;
                    }
                    ++j;
                }
                resultRequiredCapabilities.addAll(Arrays.asList(requiredAdvice));
                iu.setRequiredCapabilities(resultRequiredCapabilities.toArray(new IRequiredCapability[resultRequiredCapabilities.size()]));
            }
            if ((metaRequiredAdvice = entry.getMetaRequiredCapabilities(iu)) != null) {
                IRequiredCapability[] current = iu.getMetaRequiredCapabilities();
                HashSet<IRequiredCapability> resultMetaRequiredCapabilities = new HashSet<IRequiredCapability>(Arrays.asList(current));
                int j = 0;
                while (j < current.length) {
                    IRequiredCapability currentMetaRequiredCapability = current[j];
                    int k = 0;
                    while (k < metaRequiredAdvice.length) {
                        IRequiredCapability metaRequiredCapability = metaRequiredAdvice[k];
                        if (metaRequiredCapability.getNamespace().equals(currentMetaRequiredCapability.getNamespace()) && metaRequiredCapability.getName().equals(currentMetaRequiredCapability.getName())) {
                            resultMetaRequiredCapabilities.remove(currentMetaRequiredCapability);
                            break;
                        }
                        ++k;
                    }
                    ++j;
                }
                resultMetaRequiredCapabilities.addAll(Arrays.asList(metaRequiredAdvice));
                iu.setMetaRequiredCapabilities(resultMetaRequiredCapabilities.toArray(new IRequiredCapability[resultMetaRequiredCapabilities.size()]));
            }
            if ((providedAdvice = entry.getProvidedCapabilities(iu)) == null) continue;
            IProvidedCapability[] current = iu.getProvidedCapabilities();
            HashSet<IProvidedCapability> resultProvidedCapabilities = new HashSet<IProvidedCapability>(Arrays.asList(current));
            int j = 0;
            while (j < current.length) {
                IProvidedCapability currentProvidedCapability = current[j];
                int k = 0;
                while (k < providedAdvice.length) {
                    IProvidedCapability providedCapability = providedAdvice[k];
                    if (providedCapability.getNamespace().equals(currentProvidedCapability.getNamespace()) && providedCapability.getName().equals(currentProvidedCapability.getName())) {
                        resultProvidedCapabilities.remove(currentProvidedCapability);
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            resultProvidedCapabilities.addAll(Arrays.asList(providedAdvice));
            iu.setCapabilities(resultProvidedCapabilities.toArray(new IProvidedCapability[resultProvidedCapabilities.size()]));
        }
    }

    protected static void processTouchpointAdvice(MetadataFactory.InstallableUnitDescription iu, Map currentInstructions, IPublisherInfo info) {
        String string = iu.getId();
        Version version = iu.getVersion();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, string, version, clazz);
        if (currentInstructions == null) {
            if (advice.isEmpty()) {
                return;
            }
            currentInstructions = Collections.EMPTY_MAP;
        }
        ITouchpointData result = MetadataFactory.createTouchpointData((Map)currentInstructions);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            ITouchpointAdvice entry = (ITouchpointAdvice)i.next();
            result = entry.getTouchpointData(result);
        }
        iu.addTouchpointData(result);
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File inclusion, IPublisherInfo publisherInfo) {
        File descriptorFile;
        if (inclusion == null) {
            return;
        }
        IArtifactRepository destination = publisherInfo.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        if (destination instanceof IFileArtifactRepository && inclusion.equals(descriptorFile = ((IFileArtifactRepository)destination).getArtifactFile(descriptor))) {
            destination.addDescriptor(descriptor);
            return;
        }
        if ((publisherInfo.getArtifactOptions() & 2) == 0) {
            destination.addDescriptor(descriptor);
            return;
        }
        try {
            if (destination instanceof IFileArtifactRepository && inclusion.equals(descriptorFile = ((IFileArtifactRepository)destination).getArtifactFile(descriptor))) {
                destination.addDescriptor(descriptor);
                return;
            }
            OutputStream output = destination.getOutputStream(descriptor);
            if (output == null) {
                return;
            }
            output = new BufferedOutputStream(output);
            FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(inclusion)), (boolean)true, (OutputStream)output, (boolean)true);
        }
        catch (ProvisionException e) {
            LogHelper.log((IStatus)e.getStatus());
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
        }
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File[] inclusions, File[] exclusions, IPublisherInfo publisherInfo, FileUtils.IPathComputer prefixComputer) {
        if (inclusions == null || inclusions.length < 1) {
            return;
        }
        IArtifactRepository destination = publisherInfo.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        if ((publisherInfo.getArtifactOptions() & 2) == 0) {
            destination.addDescriptor(descriptor);
            return;
        }
        File tempFile = null;
        try {
            OutputStream output = destination.getOutputStream(descriptor);
            if (output == null) {
                return;
            }
            try {
                output = new BufferedOutputStream(output);
                tempFile = File.createTempFile("p2.generator", "");
                FileUtils.zip((File[])inclusions, (File[])exclusions, (File)tempFile, (FileUtils.IPathComputer)prefixComputer);
                if (output != null) {
                    FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(tempFile)), (boolean)true, (OutputStream)output, (boolean)true);
                }
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)e.getStatus());
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
                e.printStackTrace();
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    protected IInstallableUnit queryForIU(IPublisherResult publisherResult, String iuId, Version version) {
        InstallableUnitQuery query = null;
        SingleElementCollector collector = null;
        if (version != null && !Version.emptyVersion.equals((Object)version)) {
            query = new InstallableUnitQuery(iuId, version);
            collector = new SingleElementCollector();
        } else {
            query = new CompositeQuery(new Query[]{new InstallableUnitQuery(iuId), new LatestIUVersionQuery()});
            collector = new Collector();
        }
        NullProgressMonitor progress = new NullProgressMonitor();
        if (publisherResult != null) {
            collector = publisherResult.query((Query)query, collector, (IProgressMonitor)progress);
        }
        if (collector.isEmpty() && this.info.getMetadataRepository() != null) {
            collector = this.info.getMetadataRepository().query((Query)query, (Collector)collector, (IProgressMonitor)progress);
        }
        if (collector.isEmpty() && this.info.getContextMetadataRepository() != null) {
            collector = this.info.getContextMetadataRepository().query((Query)query, (Collector)collector, (IProgressMonitor)progress);
        }
        if (!collector.isEmpty()) {
            return (IInstallableUnit)collector.iterator().next();
        }
        return null;
    }

    protected IInstallableUnit[] queryForIUs(IPublisherResult publisherResult, String iuId, VersionRange versionRange) {
        InstallableUnitQuery query = null;
        Collector collector = new Collector();
        query = new InstallableUnitQuery(iuId, versionRange);
        NullProgressMonitor progress = new NullProgressMonitor();
        if (publisherResult != null) {
            collector = publisherResult.query((Query)query, collector, (IProgressMonitor)progress);
        }
        if (collector.isEmpty() && this.info.getMetadataRepository() != null) {
            collector = this.info.getMetadataRepository().query((Query)query, collector, (IProgressMonitor)progress);
        }
        if (collector.isEmpty() && this.info.getContextMetadataRepository() != null) {
            collector = this.info.getContextMetadataRepository().query((Query)query, collector, (IProgressMonitor)progress);
        }
        if (!collector.isEmpty()) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IInstallableUnit[])collector.toArray((Class)clazz);
        }
        return new IInstallableUnit[0];
    }

    public abstract IStatus perform(IPublisherInfo var1, IPublisherResult var2, IProgressMonitor var3);

    public void setPublisherInfo(IPublisherInfo info) {
        this.info = info;
    }
}

