/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;

public class PanelLiveView
extends JPanel {
    private JDC1394Cam theCamera;
    private Image bufImg;
    private MemoryImageSource imgSrc;
    private int[] thePixels;
    private Dimension resolution;
    public boolean showOverModulation = false;

    public PanelLiveView(JDC1394Cam cam) {
        super(null);
        try {
            this.theCamera = cam;
            this.resolution = cam.getVideoModes().getResolutionDimension();
            this.thePixels = cam.buildImageBuffer();
            DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
            this.imgSrc = new MemoryImageSource(this.resolution.width, this.resolution.height, (ColorModel)cm, this.thePixels, 0, this.resolution.width);
            this.imgSrc.setAnimated(true);
            this.imgSrc.setFullBufferUpdates(true);
            this.bufImg = this.createImage(this.imgSrc);
            this.setVisible(true);
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        try {
            this.theCamera.acquireImage(this.thePixels);
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
        this.imgSrc.newPixels();
        g.drawImage(this.bufImg, 0, 0, this.resolution.width, this.resolution.height, Color.white, this);
    }
}

