/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.config;

import java.awt.Dimension;
import java.awt.Rectangle;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.config.JLibDC1394CamRegistry;
import net.sf.jlibdc1394.event.JDC1394VideoModeAdapter;
import net.sf.jlibdc1394.event.JDC1394VideoModeListener;

public class JDC1394CamProxy {
    private int camConfigID;
    private JLibDC1394CamRegistry registry;
    private JDC1394Cam camera;
    private boolean allocated = false;
    private int[] camBuffer;
    private JDC1394VideoModeListener modeListener = new JDC1394VideoModeAdapter(){

        public void formatChanged(int newFormat) {
            this.resetCamBuffer();
        }

        public void modeChanged(int newMode) {
            this.resetCamBuffer();
        }

        public void frameRateChanged(int newFrameRate) {
            this.resetCamBuffer();
        }

        public void clipChanged(Rectangle newClip) {
            this.resetCamBuffer();
        }

        private void resetCamBuffer() {
            JDC1394CamProxy.access$002(JDC1394CamProxy.this, null);
        }
    };
    private Dimension notAllocatedResolution = new Dimension(0, 0);

    JDC1394CamProxy(int camConfigID, JLibDC1394CamRegistry regsitry, JDC1394Cam camera) {
        this.camConfigID = camConfigID;
        this.registry = regsitry;
        this.camera = camera;
        this.camera.getVideoModes().addVideoModeListener(this.modeListener);
    }

    public boolean isAllocated() {
        return this.allocated;
    }

    synchronized void setAllocated(boolean allocated) {
        this.allocated = allocated;
    }

    public void startImageAcquisition() throws JDC1394CamException {
        if (this.camera.isImageCaptureStarted()) {
            this.camera.stopImageCapture();
        }
        if (!this.camera.isImageAcquisitionStarted()) {
            this.camera.startImageAcquisition();
        }
    }

    public void startImageCapture() throws JDC1394CamException {
        if (this.camera.isImageAcquisitionStarted()) {
            this.camera.stopImageAcquisition();
        }
        if (!this.camera.isImageCaptureStarted()) {
            this.camera.startImageCapture();
        }
    }

    public Dimension getResolution() throws JDC1394CamException {
        if (!this.isAllocated()) {
            return this.notAllocatedResolution;
        }
        return this.camera.getVideoModes().getResolutionDimension();
    }

    protected void makeNotAllocatedPixels(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = 0;
        }
    }

    protected int[] getBuffer() throws JDC1394CamException {
        int requiredBufferLength;
        if (this.camBuffer == null) {
            this.camBuffer = this.camera.buildImageBuffer();
        }
        if (this.camBuffer.length != (requiredBufferLength = this.camera.getVideoModes().getResolutionDimension().width * this.camera.getVideoModes().getResolutionDimension().height)) {
            this.camBuffer = this.camera.buildImageBuffer();
        }
        return this.camBuffer;
    }

    public void acquireImage(int[] pixels) throws JDC1394CamException {
        if (!this.isAllocated()) {
            this.makeNotAllocatedPixels(pixels);
        } else {
            this.startImageAcquisition();
            this.camera.acquireImage(pixels);
        }
    }

    public int[] acquireImage() throws JDC1394CamException {
        int[] buffer = this.getBuffer();
        if (!this.isAllocated()) {
            this.makeNotAllocatedPixels(buffer);
        } else {
            this.startImageAcquisition();
            this.camera.acquireImage(buffer);
        }
        return buffer;
    }

    public void captureImage(int[] pixels) throws JDC1394CamException {
        if (!this.isAllocated()) {
            this.makeNotAllocatedPixels(pixels);
        } else {
            this.startImageCapture();
            this.camera.captureImage(pixels);
        }
    }

    public int[] captureImage() throws JDC1394CamException {
        int[] buffer = this.getBuffer();
        if (!this.isAllocated()) {
            this.makeNotAllocatedPixels(buffer);
        } else {
            this.startImageCapture();
            this.camera.captureImage(buffer);
        }
        return buffer;
    }

    static /* synthetic */ int[] access$002(JDC1394CamProxy x0, int[] x1) {
        x0.camBuffer = x1;
        return x1;
    }
}

