/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import com.rc.retroweaver.runtime.Autobox;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.core.ArrayUtils;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevMarkerUtils {
    public static void replaceMarkers(List<MarkerInfo> lst, IResource resource, String markerType, boolean removeUserEditable, IProgressMonitor monitor) {
        Object[] existingMarkers;
        try {
            existingMarkers = resource.findMarkers(markerType, false, 0);
            if (!removeUserEditable) {
                existingMarkers = ArrayUtils.filter((Object[])existingMarkers, (ICallback)new ICallback<Boolean, IMarker>(){

                    public Boolean call(IMarker marker) {
                        return Autobox.valueOf((!marker.getAttribute("userEditable", true) ? 1 : 0) != 0);
                    }

                    public /* synthetic */ Object call(Object object) {
                        return this.call((IMarker)object);
                    }
                }).toArray(new IMarker[0]);
            }
        }
        catch (CoreException e1) {
            PydevPlugin.log(e1);
            existingMarkers = new IMarker[]{};
        }
        int lastExistingUsed = 0;
        try {
            for (MarkerInfo markerInfo : lst) {
                HashMap asMap = markerInfo.getAsMap();
                if (monitor.isCanceled()) {
                    return;
                }
                if (asMap == null) continue;
                if (lastExistingUsed < existingMarkers.length) {
                    Object marker = existingMarkers[lastExistingUsed];
                    try {
                        marker.setAttributes((Map)asMap);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                    ++lastExistingUsed;
                    continue;
                }
                try {
                    MarkerUtilities.createMarker((IResource)resource, (Map)asMap, (String)markerType);
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        int i = lastExistingUsed;
        while (i < existingMarkers.length) {
            try {
                existingMarkers[i].delete();
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
            ++i;
        }
    }

    public static void replaceMarkers(List<MarkerInfo> lst, IResource resource, String markerType, IProgressMonitor monitor) {
        PydevMarkerUtils.replaceMarkers(lst, resource, markerType, true, monitor);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MarkerInfo {
        public IDocument doc;
        public String message;
        public String markerType;
        public int severity;
        public boolean userEditable;
        public boolean isTransient;
        public int lineStart;
        public int colStart;
        public int lineEnd;
        public int absoluteStart = -1;
        public int absoluteEnd = -1;
        public int colEnd;
        public Map<String, Object> additionalInfo;

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int lineStart, int colStart, int lineEnd, int colEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = lineStart;
            this.colStart = colStart;
            this.lineEnd = lineEnd;
            this.colEnd = colEnd;
            this.additionalInfo = additionalInfo;
        }

        public MarkerInfo(IDocument doc, String message, String markerType, int severity, boolean userEditable, boolean isTransient, int line, int absoluteStart, int absoluteEnd, Map<String, Object> additionalInfo) {
            this.doc = doc;
            this.message = message;
            this.markerType = markerType;
            this.severity = severity;
            this.userEditable = userEditable;
            this.isTransient = isTransient;
            this.lineStart = line;
            this.lineEnd = line;
            this.absoluteStart = absoluteStart;
            this.absoluteEnd = absoluteEnd;
            this.additionalInfo = additionalInfo;
        }

        private HashMap<String, Object> getAsMap() throws BadLocationException {
            if (this.lineStart < 0) {
                this.lineStart = 0;
            }
            if (this.absoluteStart == -1 || this.absoluteEnd == -1) {
                IRegion start;
                try {
                    start = this.doc.getLineInformation(this.lineStart);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                catch (Exception e) {
                    Log.log((int)4, (String)new StringBuffer("Could not get line: ").append(this.lineStart).append(" to add message: ").append(this.message).toString(), (Throwable)e);
                    return null;
                }
                try {
                    this.absoluteStart = start.getOffset() + this.colStart;
                    if (this.lineEnd >= 0 && this.colEnd >= 0) {
                        IRegion end = this.doc.getLineInformation(this.lineEnd);
                        this.absoluteEnd = end.getOffset() + this.colEnd;
                    } else {
                        String line = this.doc.get(start.getOffset(), start.getLength());
                        int i = line.indexOf(35);
                        FastStringBuffer buffer = i != -1 ? new FastStringBuffer(line.substring(0, i), 0) : new FastStringBuffer(line, 0);
                        while (buffer.length() > 0 && Character.isWhitespace(buffer.lastChar())) {
                            buffer.deleteLast();
                        }
                        this.absoluteEnd = start.getOffset() + buffer.length();
                    }
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                catch (Exception e) {
                    Log.log((int)1, (String)new StringBuffer("Problem creating map for:").append(this.toString()).toString(), (Throwable)e);
                    return null;
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("message", this.message);
            map.put("lineNumber", Autobox.valueOf((int)this.lineStart));
            map.put("charStart", Autobox.valueOf((int)this.absoluteStart));
            map.put("charEnd", Autobox.valueOf((int)this.absoluteEnd));
            map.put("severity", Autobox.valueOf((int)this.severity));
            map.put("userEditable", Autobox.valueOf((boolean)this.userEditable));
            map.put("transient", Autobox.valueOf((boolean)this.isTransient));
            if (this.additionalInfo != null) {
                map.putAll(this.additionalInfo);
            }
            return map;
        }

        public String toString() {
            StringBuffer retValue = new StringBuffer();
            retValue.append("MarkerInfo (\n").append("doc = ").append(this.doc).append("\n").append("message = ").append(this.message).append("\n").append("markerType = ").append(this.markerType).append("\n").append("severity = ").append(this.severity).append("\n").append("userEditable = ").append(this.userEditable).append("\n").append("isTransient = ").append(this.isTransient).append("\n").append("lineStart = ").append(this.lineStart).append("\n").append("colStart = ").append(this.colStart).append("\n").append("lineEnd = ").append(this.lineEnd).append("\n").append("absoluteStart = ").append(this.absoluteStart).append("\n").append("absoluteEnd = ").append(this.absoluteEnd).append("\n").append("colEnd = ").append(this.colEnd).append("\n").append("additionalInfo = ").append(this.additionalInfo).append("\n").append(")");
            return retValue.toString();
        }
    }
}

