/*
 * Decompiled with CFR 0.152.
 */
package org.pf.textx;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.Vector;
import org.pf.text.StringUtil;
import org.pf.textx.FunctionResolver;
import org.pf.textx.InvalidParameterException;
import org.pf.textx.TextReplacementException;
import org.pf.textx.TextRepresentation;
import org.pf.textx.UnknownFunctionException;
import org.pf.textx.UnknownVariableException;
import org.pf.textx.VariableResolver;
import org.pf.util.Bool;

public class TextEngine {
    protected static final Character DEFAULT_VAR_START_DELIMITER = new Character('%');
    protected static final Character DEFAULT_VAR_END_DELIMITER = new Character('%');
    protected static final Character DEFAULT_TEXT_DELIMITER = new Character('\'');
    protected static final Character DEFAULT_PARAM_SEPARATOR = new Character(',');
    protected static final Character DEFAULT_FUNCPARAM_START = new Character('(');
    protected static final Character DEFAULT_FUNCPARAM_END = new Character(')');
    protected static final Character CONTROL_INDICATOR = new Character('#');
    protected static final String CONTROL_IF = "IF";
    protected static final String CONTROL_ELSE = "ELSE";
    protected static final String CONTROL_ENDIF = "ENDIF";
    protected static final String CONTROL_IFDEF = "IFDEF";
    protected static final int EMPTY_CACHE = -99;
    private VariableResolver variableResolver = null;
    private FunctionResolver functionResolver = null;
    private StringReader sourceBuffer = null;
    private StringWriter resultBuffer = null;
    private Character nextChar = null;
    private boolean nextCharFilled = false;
    private int charCache = -99;
    private Stack executionControl = new Stack();
    private boolean supressMissingVariableException = false;
    private Character varStartPrefix = null;
    private Character varStartDelimiter = DEFAULT_VAR_START_DELIMITER;
    private Character varEndDelimiter = DEFAULT_VAR_END_DELIMITER;
    private String indentationFiller = null;
    private String specialNameCharacters = "";

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver vr) {
        this.variableResolver = vr;
    }

    public FunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public void setFunctionResolver(FunctionResolver fr) {
        this.functionResolver = fr;
    }

    protected StringReader getSourceBuffer() {
        return this.sourceBuffer;
    }

    protected void setSourceBuffer(StringReader sb) {
        this.sourceBuffer = sb;
    }

    protected StringWriter getResultBuffer() {
        return this.resultBuffer;
    }

    protected void setResultBuffer(StringWriter rb) {
        this.resultBuffer = rb;
    }

    protected Character getNextChar() {
        return this.nextChar;
    }

    protected void setNextChar(Character ch) {
        this.nextChar = ch;
    }

    protected boolean getNextCharFilled() {
        return this.nextCharFilled;
    }

    protected void setNextCharFilled(boolean flag) {
        this.nextCharFilled = flag;
    }

    protected int getCharCache() {
        return this.charCache;
    }

    protected void setCharCache(int newValue) {
        this.charCache = newValue;
    }

    protected Stack getExecutionControl() {
        return this.executionControl;
    }

    protected void setExecutionControl(Stack newValue) {
        this.executionControl = newValue;
    }

    protected boolean supressMissingVariableException() {
        return this.supressMissingVariableException;
    }

    protected void supressMissingVariableException(boolean newValue) {
        this.supressMissingVariableException = newValue;
    }

    public Character getVarStartPrefix() {
        return this.varStartPrefix;
    }

    public void setVarStartPrefix(Character prefix) {
        this.varStartPrefix = prefix;
    }

    public Character getVarStartDelimiter() {
        return this.varStartDelimiter;
    }

    public void setVarStartDelimiter(Character newValue) {
        this.varStartDelimiter = newValue;
    }

    public Character getVarEndDelimiter() {
        return this.varEndDelimiter;
    }

    public void setVarEndDelimiter(Character newValue) {
        this.varEndDelimiter = newValue;
    }

    protected String getIndentationFiller() {
        return this.indentationFiller;
    }

    protected void setIndentationFiller(String newValue) {
        this.indentationFiller = newValue;
    }

    public String getSpecialNameCharacters() {
        return this.specialNameCharacters;
    }

    public void setSpecialNameCharacters(String newValue) {
        this.specialNameCharacters = newValue;
    }

    public TextEngine(VariableResolver varResolver) {
        this.setVariableResolver(varResolver);
    }

    public TextEngine(VariableResolver varResolver, FunctionResolver funcResolver) {
        this(varResolver);
        this.setFunctionResolver(funcResolver);
    }

    public String completeText(String text) throws TextReplacementException {
        this.initializeBuffers(text);
        this.copyText();
        return this.resultString();
    }

    public void setIndentation(int indentSize) {
        if (indentSize <= 0) {
            this.setIndentationFiller(null);
        } else {
            this.setIndentationFiller(this.strUtil().repeat(' ', indentSize));
        }
    }

    public void setVarStartDelimiter(char newValue) {
        this.setVarStartDelimiter(new Character(newValue));
    }

    public void setVarEndDelimiter(char newValue) {
        this.setVarEndDelimiter(new Character(newValue));
    }

    public void useDollarCurlyBrackets() {
        this.setVarStartPrefix(new Character('$'));
        this.setVarStartDelimiter(new Character('{'));
        this.setVarEndDelimiter(new Character('}'));
    }

    public void allowMissingPlaceholders() {
        this.supressMissingVariableException(true);
    }

    public void forbidMissingPlaceholders() {
        this.supressMissingVariableException(false);
    }

    protected void initializeResultBuffer(int initialCapacity) {
        this.setResultBuffer(new StringWriter(initialCapacity));
        if (this.isIndentationOn()) {
            this.getResultBuffer().write(this.getIndentationFiller());
        }
    }

    protected void initializeSourceBuffer(String source) {
        this.setSourceBuffer(new StringReader(source));
    }

    protected void initializeBuffers(String text) {
        this.initializeResultBuffer(text.length());
        this.initializeSourceBuffer(text);
    }

    protected void copyText() throws TextReplacementException {
        Character ch = null;
        while (this.hasMoreChars()) {
            ch = this.nextCharacter();
            if (this.isInsertionStart(ch)) {
                this.writeToResultBuffer(this.getPlaceholderValue());
                continue;
            }
            this.writeToResultBuffer(ch.charValue());
            if (!this.isIndentationOn() || ch.charValue() != '\n') continue;
            this.writeToResultBuffer(this.getIndentationFiller());
        }
    }

    protected boolean isInsertionStart(Character ch) {
        if (this.hasDelimiterPrefix()) {
            if (ch.equals(this.getVarStartPrefix())) {
                ch = this.nextCharacter();
                if (ch.equals(this.getVarStartDelimiter())) {
                    return true;
                }
                this.putBackNextChar();
            }
            return false;
        }
        return ch.equals(this.getVarStartDelimiter());
    }

    protected boolean hasDelimiterPrefix() {
        return this.getVarStartPrefix() != null;
    }

    protected void writeToResultBuffer(String text) {
        if (this.isWritingOn()) {
            this.getResultBuffer().write(text);
        }
    }

    protected void writeToResultBuffer(char ch) {
        if (this.isWritingOn()) {
            this.getResultBuffer().write(ch);
        }
    }

    protected String getPlaceholderName() {
        StringBuffer buffer = new StringBuffer(40);
        while (this.hasMoreChars()) {
            Character ch = this.nextCharacter();
            if (this.isValidPlaceholderNameCharacter(ch.charValue())) {
                buffer.append(ch);
                continue;
            }
            this.putBackNextChar();
            break;
        }
        return buffer.toString();
    }

    protected String getPlaceholderValue() throws TextReplacementException {
        Character ch = null;
        String placeholderName = null;
        if (!this.hasMoreChars()) {
            throw new TextReplacementException("Unexpected end of string reached !");
        }
        ch = this.nextCharacter();
        if (ch.equals(this.getVarStartDelimiter())) {
            return this.getVarStartDelimiter().toString();
        }
        if (ch.equals(this.getControlIndicator())) {
            return this.evaluateControl();
        }
        this.putBackNextChar();
        placeholderName = this.getPlaceholderName();
        ch = this.nextCharacter();
        if (ch.equals(this.getVarEndDelimiter())) {
            return this.evaluatePlaceholder(placeholderName);
        }
        if (ch.equals(this.getFunctionParameterStart())) {
            return this.evaluateFunction(placeholderName);
        }
        throw new TextReplacementException("Invalid termination of placeholder: " + placeholderName);
    }

    protected void checkEndAfterFunction(String funcName) throws TextReplacementException {
        Character ch = null;
        String msg = null;
        ch = this.skipSpaces();
        if (!ch.equals(this.getVarEndDelimiter())) {
            msg = "Invalid character '" + ch + "' after '" + funcName + "' !";
            throw new TextReplacementException(msg);
        }
    }

    protected void checkFunctionStart(String funcName) throws TextReplacementException {
        Character ch = null;
        String msg = null;
        ch = this.skipSpaces();
        if (!ch.equals(this.getFunctionParameterStart())) {
            msg = "Missing opening bracket in '" + funcName + "' ! ";
            throw new TextReplacementException(msg);
        }
    }

    protected void checkFunctionEnd(String funcName) throws TextReplacementException {
        Character ch = null;
        String msg = null;
        ch = this.skipSpaces();
        if (!ch.equals(this.getFunctionParameterEnd())) {
            msg = "Invalid end '" + ch + "' of " + funcName;
            throw new TextReplacementException(msg);
        }
    }

    protected void checkParameterCount(String funcName, int expected, int actual) throws TextReplacementException {
        String msg = null;
        if (actual != expected) {
            msg = "The number of parameters in " + funcName + " must be ";
            msg = String.valueOf(msg) + Integer.toString(expected) + " !";
            throw new TextReplacementException(msg);
        }
    }

    protected String evaluateControlIF() throws TextReplacementException {
        String IF_CTRL = CONTROL_IF + this.getFunctionParameterStart() + this.getFunctionParameterEnd();
        this.checkFunctionStart(IF_CTRL);
        Vector parameters = this.getFunctionParameters();
        this.checkFunctionEnd(IF_CTRL);
        this.checkEndAfterFunction(IF_CTRL);
        this.checkParameterCount(IF_CTRL, 1, parameters.size());
        if (Bool.get((String)parameters.get(0)).isTrue()) {
            this.switchWritingOn();
        } else {
            this.switchWritingOff();
        }
        return "";
    }

    protected String evaluateControlIFDEF() throws TextReplacementException {
        String IFDEF_CTRL = CONTROL_IFDEF + this.getFunctionParameterStart() + this.getFunctionParameterEnd();
        String varName = null;
        this.checkFunctionStart(IFDEF_CTRL);
        varName = this.getFunctionParameterName();
        this.checkFunctionEnd(IFDEF_CTRL);
        this.checkEndAfterFunction(IFDEF_CTRL);
        if (this.isDefinedPlaceholder(varName) && this.evaluatePlaceholder(varName).length() > 0) {
            this.switchWritingOn();
        } else {
            this.switchWritingOff();
        }
        return "";
    }

    protected String evaluateControlELSE() throws TextReplacementException {
        this.checkEndAfterFunction(CONTROL_ELSE);
        try {
            this.toggleWritingSwitch();
        }
        catch (EmptyStackException ex) {
            throw new TextReplacementException("Unmatched ELSE reached !");
        }
        return "";
    }

    protected String evaluateControlENDIF() throws TextReplacementException {
        this.checkEndAfterFunction(CONTROL_ENDIF);
        try {
            this.removeLastWritingSwitch();
        }
        catch (EmptyStackException ex) {
            throw new TextReplacementException("Unmatched ENDIF reached !");
        }
        return "";
    }

    protected String evaluateControl() throws TextReplacementException {
        String controlName = null;
        String msg = null;
        controlName = this.getPlaceholderName();
        if (controlName.equals(CONTROL_IF)) {
            return this.evaluateControlIF();
        }
        if (controlName.equals(CONTROL_ENDIF)) {
            return this.evaluateControlENDIF();
        }
        if (controlName.equals(CONTROL_ELSE)) {
            return this.evaluateControlELSE();
        }
        if (controlName.equals(CONTROL_IFDEF)) {
            return this.evaluateControlIFDEF();
        }
        msg = "Unknown control element: " + CONTROL_INDICATOR + controlName;
        throw new TextReplacementException(msg);
    }

    protected String getTextConstant() throws TextReplacementException {
        Character ch = null;
        boolean ready = false;
        StringBuffer buffer = new StringBuffer(100);
        while (this.hasMoreChars() && !ready) {
            ch = this.nextCharacter();
            if (ch.equals(this.getTextDelimiter())) {
                if (this.hasMoreChars()) {
                    ch = this.nextCharacter();
                    if (ch.equals(this.getTextDelimiter())) {
                        buffer.append(ch.toString());
                        continue;
                    }
                    ready = true;
                    this.putBackNextChar();
                    continue;
                }
                ready = true;
                continue;
            }
            buffer.append(ch.toString());
        }
        return buffer.toString();
    }

    protected String asString(Object anObject) {
        String resultString = null;
        resultString = anObject instanceof TextRepresentation ? ((TextRepresentation)anObject).asText() : anObject.toString();
        return resultString;
    }

    protected String evaluatePlaceholder(String varName) throws UnknownVariableException {
        if (this.isWritingOn()) {
            Object value;
            if (this.supressMissingVariableException()) {
                try {
                    value = this.getVariableResolver().getValue(varName);
                }
                catch (UnknownVariableException e) {
                    value = varName;
                }
            } else {
                value = this.getVariableResolver().getValue(varName);
            }
            return this.asString(value);
        }
        return "";
    }

    protected boolean isDefinedPlaceholder(String varName) {
        return this.getVariableResolver().isKnownVariable(varName);
    }

    protected Vector getFunctionParameters() throws TextReplacementException {
        Character ch = null;
        Vector<String> parameters = new Vector<String>();
        String arg = null;
        String varName = null;
        ch = this.skipSpaces();
        do {
            if (ch.equals(this.getTextDelimiter())) {
                arg = this.getTextConstant();
            } else {
                this.putBackNextChar();
                varName = this.getPlaceholderName();
                arg = this.evaluatePlaceholder(varName);
            }
            parameters.add(arg);
        } while ((ch = this.skipSpaces()).equals(this.getFunctionParameterSeparator()));
        this.putBackNextChar();
        return parameters;
    }

    protected String getFunctionParameterName() throws TextReplacementException {
        Character ch = null;
        String varName = null;
        ch = this.skipSpaces();
        if (ch.equals(this.getTextDelimiter())) {
            throw new TextReplacementException("No text constant allowed here !");
        }
        this.putBackNextChar();
        varName = this.getPlaceholderName();
        return varName;
    }

    protected String evaluateFunction(String funcName, Vector parameter) throws UnknownFunctionException, InvalidParameterException {
        if (this.getFunctionResolver() == null) {
            throw new UnknownFunctionException(funcName);
        }
        return this.asString(this.getFunctionResolver().executeFunction(funcName, parameter));
    }

    protected String evaluateFunction(String funcName) throws TextReplacementException {
        Vector parameters = this.getFunctionParameters();
        this.checkFunctionEnd(funcName);
        this.checkEndAfterFunction(funcName);
        return this.evaluateFunction(funcName, parameters);
    }

    protected void readAhead() throws IOException {
        int readResult = -1;
        if (this.getCharCache() == -99) {
            readResult = this.getSourceBuffer().read();
            if (readResult < 0) {
                throw new IOException("End of String");
            }
            this.setCharCache(readResult);
        }
    }

    protected void readNext() throws IOException {
        char ch = '@';
        this.readAhead();
        ch = (char)this.getCharCache();
        this.setCharCache(-99);
        this.setNextChar(new Character(ch));
        this.setNextCharFilled(true);
    }

    protected boolean hasMoreChars() {
        boolean hasChar = true;
        if (this.isNextCharBufferEmpty()) {
            try {
                this.readAhead();
            }
            catch (IOException ex) {
                hasChar = false;
            }
        }
        return hasChar;
    }

    protected Character nextChar() throws IOException {
        if (this.isNextCharBufferEmpty()) {
            this.readNext();
        }
        this.setNextCharFilled(false);
        return this.getNextChar();
    }

    protected Character nextCharacter() {
        Character ch = null;
        try {
            ch = this.nextChar();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ch;
    }

    protected void putBackNextChar() {
        if (this.isNextCharBufferEmpty()) {
            this.setNextCharFilled(true);
        }
    }

    protected boolean isNextCharBufferEmpty() {
        return !this.getNextCharFilled();
    }

    protected Character skipSpaces() {
        Character ch = new Character(' ');
        while (this.hasMoreChars() && Character.isWhitespace(ch.charValue())) {
            ch = this.nextCharacter();
        }
        return ch;
    }

    protected String resultString() {
        return this.getResultBuffer().toString();
    }

    protected Character getFunctionParameterStart() {
        return DEFAULT_FUNCPARAM_START;
    }

    protected Character getFunctionParameterEnd() {
        return DEFAULT_FUNCPARAM_END;
    }

    protected Character getFunctionParameterSeparator() {
        return DEFAULT_PARAM_SEPARATOR;
    }

    protected Character getTextDelimiter() {
        return DEFAULT_TEXT_DELIMITER;
    }

    protected boolean isValidPlaceholderNameCharacter(char ch) {
        return Character.isJavaIdentifierStart(ch) || Character.isDigit(ch) || this.getSpecialNameCharacters().indexOf(ch) >= 0;
    }

    protected Character getControlIndicator() {
        return CONTROL_INDICATOR;
    }

    protected boolean isIndentationOn() {
        return this.getIndentationFiller() != null;
    }

    protected boolean isWritingOn() {
        boolean bool = true;
        if (this.getExecutionControl().empty()) {
            return true;
        }
        try {
            bool = ((Bool)this.getExecutionControl().peek()).isTrue();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return bool;
    }

    protected boolean isConditionalControlOn() {
        return !this.getExecutionControl().empty();
    }

    protected void removeLastWritingSwitch() throws EmptyStackException {
        this.getExecutionControl().pop();
    }

    protected void switchWritingTo(Bool bool) {
        this.getExecutionControl().push(bool);
    }

    protected void toggleWritingSwitch() throws EmptyStackException {
        Bool old = (Bool)this.getExecutionControl().pop();
        this.getExecutionControl().push(old.not());
    }

    protected void switchWritingOn() {
        this.switchWritingTo(Bool.getTrue());
    }

    protected void switchWritingOff() {
        this.switchWritingTo(Bool.getFalse());
    }

    protected StringUtil strUtil() {
        return StringUtil.current();
    }
}

