/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

class MatchRuleTypeConverter {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public Object convertToType(Object object, Object type) {
        if (object instanceof String) {
            return this.convertToType((String)object, type);
        }
        if (object instanceof Collection) {
            return this.convertToType((Collection)object, type);
        }
        if (object instanceof Object[]) {
            return this.convertToType((Object[])object, type);
        }
        if (object instanceof Integer) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (type == clazz) {
                return this.convertToLong((Integer)object);
            }
        }
        return object;
    }

    public Object convertToType(String strValue, Object type) {
        if (strValue == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.convertToInteger(strValue);
        }
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.convertToLong(strValue);
        }
        if (type instanceof SimpleDateFormat) {
            return this.convertToDate(strValue, (SimpleDateFormat)type);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.convertToFloat(strValue);
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            return this.convertToDouble(strValue);
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5) {
            return this.convertToBigDecimal(strValue);
        }
        throw new IllegalArgumentException("Type " + type + " not supported.");
    }

    public Collection convertToType(Collection collection, Object type) {
        if (this.isNullOrEmpty(collection)) {
            return null;
        }
        Collection result = this.newCollectionOfType(collection.getClass());
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object element = this.convertToType(iter.next(), type);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public Object[] convertToType(Object[] values, Object type) {
        Object[] result;
        if (values == null) {
            return null;
        }
        if (type instanceof SimpleDateFormat) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = this.newArrayOfType(clazz, values.length);
        } else {
            result = this.newArrayOfType((Class)type, values.length);
        }
        int i = 0;
        while (i < values.length) {
            result[i] = this.convertToType(values[i], type);
            ++i;
        }
        return result;
    }

    public Float convertToFloat(String strValue) {
        return Float.valueOf(strValue);
    }

    public Double convertToDouble(String strValue) {
        return Double.valueOf(strValue);
    }

    public BigDecimal convertToBigDecimal(String strValue) {
        return new BigDecimal(strValue);
    }

    public Integer convertToInteger(String str) {
        return Integer.valueOf(str);
    }

    public Long convertToLong(String str) {
        return Long.valueOf(str);
    }

    public Date convertToDate(String strValue, SimpleDateFormat dateFormat) {
        try {
            return dateFormat.parse(strValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to convert '" + strValue + "' to Date with format \"" + dateFormat.toPattern() + "\"");
        }
    }

    public Long[] convertToLong(Integer[] intValues) {
        Long[] longValues = new Long[intValues.length];
        int i = 0;
        while (i < intValues.length) {
            longValues[i] = this.convertToLong(intValues[i]);
            ++i;
        }
        return longValues;
    }

    public Long convertToLong(Integer intValue) {
        return new Long(intValue.longValue());
    }

    protected Collection newCollectionOfType(Class collectionType) {
        try {
            return (Collection)collectionType.newInstance();
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    protected Object[] newArrayOfType(Class elementType, int length) {
        return (Object[])Array.newInstance(elementType, length);
    }

    protected boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    protected boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    protected void addAll(Collection collection, Object[] array) {
        if (collection != null && array != null) {
            int i = 0;
            while (i < array.length) {
                collection.add(array[i]);
                ++i;
            }
        }
    }
}

