/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pf.text.MatchAttribute;
import org.pf.text.MatchElement;
import org.pf.text.MatchRuleException;
import org.pf.text.MatchRuleVisitor;
import org.pf.text.StringPattern;

public class MatchGroup
extends MatchElement
implements Serializable {
    private List elements = null;

    protected List getElements() {
        return this.elements;
    }

    protected void setElements(List newValue) {
        this.elements = newValue;
    }

    public MatchGroup() {
        this.setElements(this.newElementList());
    }

    public void addElement(MatchElement element) {
        this.getElements().add(element);
    }

    public boolean isGroup() {
        return true;
    }

    public int elementCount() {
        return this.getElements().size();
    }

    protected MatchElement getElement(int index) {
        return (MatchElement)this.getElements().get(index);
    }

    protected boolean doMatch(Map dictionary) {
        Iterator iterator = null;
        MatchElement element = null;
        boolean matched = true;
        boolean isFirst = true;
        iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            element = (MatchElement)iterator.next();
            if (isFirst) {
                isFirst = false;
                matched = element.matches(dictionary);
                continue;
            }
            if (element.getAnd()) {
                matched = matched && element.matches(dictionary);
                continue;
            }
            boolean bl = matched = matched || element.matches(dictionary);
        }
        return matched;
    }

    protected void ignoreCase(boolean ignoreIt) {
        int i = 0;
        while (i < this.getElements().size()) {
            this.getElement(i).ignoreCase(ignoreIt);
            ++i;
        }
    }

    public void ignoreCaseInName(boolean ignoreIt) {
        int i = 0;
        while (i < this.getElements().size()) {
            this.getElement(i).ignoreCaseInName(ignoreIt);
            ++i;
        }
    }

    protected void multiCharWildcardMatchesEmptyString(boolean yesOrNo) {
        int i = 0;
        while (i < this.getElements().size()) {
            this.getElement(i).multiCharWildcardMatchesEmptyString(yesOrNo);
            ++i;
        }
    }

    protected void apply(MatchRuleVisitor visitor) {
        visitor.startGroup(this.getAnd(), this.getNot());
        int i = 0;
        while (i < this.getElements().size()) {
            this.getElement(i).apply(visitor);
            ++i;
        }
        visitor.endGroup();
    }

    protected void applyDatatypes(Map datatypes) throws MatchRuleException {
        int i = 0;
        while (i < this.getElements().size()) {
            this.getElement(i).applyDatatypes(datatypes);
            ++i;
        }
    }

    protected void optimize() {
        int i = 0;
        while (i < this.elementCount()) {
            if (this.getElement(i).isAttribute()) {
                this.optimizeAttribute(i);
            } else {
                MatchGroup group = (MatchGroup)this.getElement(i);
                group.optimize();
            }
            ++i;
        }
    }

    protected void optimizeAttribute(int index) {
        ArrayList patterns = null;
        boolean optimized = false;
        boolean done = false;
        if (!this.getElement(index).isAttribute()) {
            return;
        }
        MatchAttribute attr = (MatchAttribute)this.getElement(index);
        int i = index + 1;
        while (!done && i < this.elementCount()) {
            MatchAttribute otherAttr;
            done = true;
            if (this.getElement(i).isAttribute() && !(otherAttr = (MatchAttribute)this.getElement(i)).getNot() && !otherAttr.getAnd() && attr.getAttributeName().equals(otherAttr.getAttributeName())) {
                done = false;
                if (!optimized) {
                    optimized = true;
                    patterns = new ArrayList(attr.getPatterns().length + otherAttr.getPatterns().length);
                    this.addAll(patterns, attr.getPatterns());
                }
                this.addAll(patterns, otherAttr.getPatterns());
            }
            ++i;
        }
        if (optimized) {
            attr.setPatterns(patterns.toArray(new StringPattern[patterns.size()]));
            this.removeElements(index + 1, i - 1);
        }
    }

    protected void addAll(Collection coll, StringPattern[] patternArray) {
        int i = 0;
        while (i < patternArray.length) {
            coll.add(patternArray[i]);
            ++i;
        }
    }

    protected void removeElements(int from, int to) {
        List list = this.newElementList();
        int i = 0;
        while (i < this.elementCount()) {
            if (i < from || i > to) {
                list.add(this.getElement(i));
            }
            ++i;
        }
        this.setElements(list);
    }

    protected List newElementList() {
        return new ArrayList();
    }
}

