/*
 * Decompiled with CFR 0.152.
 */
package org.pf.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.pf.logging.Logger;

public class PrintStreamLogger
implements Logger {
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_DEBUG = 4;
    public static final String LL_NONE = "NONE";
    public static final String LL_ERROR = "ERROR";
    public static final String LL_WARNING = "WARNING";
    public static final String LL_INFO = "INFO";
    public static final String LL_DEBUG = "DEBUG";
    public static final String PROP_OUTPUT_FILE = "logging.printstream.file";
    public static final String PROP_LOG_LEVEL = "logging.level";
    private static final String[] LEVEL_INDICATOR = new String[]{"", "E", "W", "I", "D", "X"};
    private int logLevel = 1;
    private PrintStream printStream = System.out;

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int newLevel) {
        this.logLevel = newLevel;
    }

    protected PrintStream getPrintStream() {
        return this.printStream;
    }

    protected void setPrintStream(PrintStream newValue) {
        this.printStream = newValue;
    }

    public void initialize(Properties properties) {
        String value = null;
        if (properties != null) {
            value = properties.getProperty(PROP_OUTPUT_FILE);
            this.initPrintStream(value);
            value = properties.getProperty(PROP_LOG_LEVEL);
            this.initLogLevel(value);
        }
    }

    public void logException(Throwable ex) {
        this.printException(ex);
    }

    public void logDebug(String message) {
        if (this.isLoggingDebugs()) {
            this.println(4, message);
        }
    }

    public void logInfo(String message) {
        if (this.isLoggingInfos()) {
            this.println(3, message);
        }
    }

    public void logWarning(String message) {
        if (this.isLoggingWarnings()) {
            this.println(2, message);
        }
    }

    public void logError(String message) {
        if (this.isLoggingErrors()) {
            this.println(1, message);
        }
    }

    public void logWarning(String message, Throwable exception) {
        if (this.isLoggingWarnings()) {
            this.println(2, message);
            this.printException(exception);
        }
    }

    public void logError(String message, Throwable exception) {
        if (this.isLoggingErrors()) {
            this.println(1, message);
            this.printException(exception);
        }
    }

    public boolean isLoggingDebugs() {
        return this.getLogLevel() >= 4;
    }

    public boolean isLoggingInfos() {
        return this.getLogLevel() >= 3;
    }

    public boolean isLoggingWarnings() {
        return this.getLogLevel() >= 2;
    }

    public boolean isLoggingErrors() {
        return this.getLogLevel() >= 1;
    }

    public boolean setLogLevel(String logLevel) {
        return this.initLogLevel(logLevel);
    }

    protected void print(String text) {
        this.getPrintStream().print(text);
    }

    protected void print(int level, String text) {
        if (this.useLevelIndicators()) {
            this.print(this.getLevelIndicator(level));
            this.print(" ");
        }
        this.print(text);
    }

    protected void println(String text) {
        this.print(text);
        this.print("\n");
    }

    protected void println(int level, String text) {
        this.print(level, text);
        this.println();
    }

    protected void println() {
        this.println("");
    }

    protected void printException(Throwable ex) {
        ex.printStackTrace(this.getPrintStream());
    }

    protected String getLevelIndicator(int level) {
        if (level < 0 || level >= LEVEL_INDICATOR.length) {
            return LEVEL_INDICATOR[LEVEL_INDICATOR.length - 1];
        }
        return LEVEL_INDICATOR[level];
    }

    protected boolean useLevelIndicators() {
        return true;
    }

    protected void initPrintStream(String filename) {
        File file = null;
        FileOutputStream os = null;
        PrintStream ps = null;
        if (filename != null) {
            try {
                file = new File(filename);
                os = new FileOutputStream(file);
                ps = new PrintStream(os);
                this.setPrintStream(ps);
            }
            catch (IOException ex) {
                this.logError("Failed to create file '" + filename + "' for logging", ex);
            }
        }
    }

    protected boolean initLogLevel(String level) {
        if (level == null) {
            return false;
        }
        String levelName = level.toUpperCase();
        if (LL_NONE.equals(levelName)) {
            this.setLogLevel(0);
        } else if (LL_ERROR.equals(levelName)) {
            this.setLogLevel(1);
        } else if (LL_WARNING.equals(levelName)) {
            this.setLogLevel(2);
        } else if (LL_INFO.equals(levelName)) {
            this.setLogLevel(3);
        } else if (LL_DEBUG.equals(levelName)) {
            this.setLogLevel(4);
        } else {
            return false;
        }
        return true;
    }
}

