/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import org.pf.file.FileFinder;
import org.pf.file.FileLocator;
import org.pf.file.FileUtil;
import org.pf.file.LineProcessor;
import org.pf.file.LoggerProvider;
import org.pf.file.PropertiesFileContent;

public class PropertyFileLoader
implements LineProcessor {
    private PropertiesFileContent properties = null;

    protected PropertiesFileContent getProperties() {
        return this.properties;
    }

    protected void setProperties(PropertiesFileContent newValue) {
        this.properties = newValue;
    }

    public static Properties loadProperties(String filename) {
        return PropertyFileLoader.loadProperties(filename, null);
    }

    public static Properties loadProperties(String filename, Properties defaults) {
        URL url = null;
        url = FileFinder.locateFile(filename);
        if (url == null) {
            return null;
        }
        return PropertyFileLoader.loadProperties(url, defaults);
    }

    public static Properties loadProperties(File file) {
        return PropertyFileLoader.loadProperties(file, null);
    }

    public static Properties loadProperties(File file, Properties defaults) {
        return PropertyFileLoader.loadProperties(FileLocator.create(file), defaults);
    }

    public static Properties loadProperties(FileLocator locator) {
        return PropertyFileLoader.loadProperties(locator, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(FileLocator locator, Properties defaults) {
        Properties properties = null;
        InputStream stream = null;
        try {
            try {
                if (locator.exists()) {
                    stream = locator.getInputStream();
                    properties = PropertyFileLoader.loadProperties(stream, defaults);
                }
            }
            catch (Exception ex) {
                LoggerProvider.getLogger().logException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            FileUtil.current().close(stream);
            throw throwable;
        }
        {
            Object var5_7 = null;
            FileUtil.current().close(stream);
        }
        return properties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadProperties(URL url, Properties defaults) {
        Properties properties = null;
        InputStream stream = null;
        try {
            try {
                stream = url.openStream();
                properties = PropertyFileLoader.loadProperties(stream, defaults);
            }
            catch (Exception ex) {
                LoggerProvider.getLogger().logException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            FileUtil.current().close(stream);
            throw throwable;
        }
        {
            Object var5_7 = null;
            FileUtil.current().close(stream);
        }
        return properties;
    }

    public static Properties loadProperties(InputStream stream, Properties defaults) throws IOException {
        Properties properties = null;
        if (stream != null) {
            properties = defaults == null ? new Properties() : new Properties(defaults);
            properties.load(stream);
        }
        return properties;
    }

    public static Properties loadProperties(InputStream stream) throws IOException {
        return PropertyFileLoader.loadProperties(stream, null);
    }

    public static PropertiesFileContent loadFullPropertiesFile(String filename) throws IOException {
        PropertyFileLoader loader = new PropertyFileLoader();
        return loader.loadFrom(FileLocator.create(filename));
    }

    public static PropertiesFileContent loadFullPropertiesFile(Reader reader) throws IOException {
        PropertyFileLoader loader = new PropertyFileLoader();
        return loader.loadFrom(reader);
    }

    public static PropertiesFileContent loadFullPropertiesFile(InputStream stream) throws IOException {
        PropertyFileLoader loader = new PropertyFileLoader();
        return loader.loadFrom(stream);
    }

    private PropertyFileLoader() {
    }

    public boolean processLine(String line, int lineNo) {
        this.getProperties().addLine(line);
        return true;
    }

    protected PropertiesFileContent loadFrom(FileLocator locator) throws IOException {
        return this.loadFrom(locator.getInputStream());
    }

    protected PropertiesFileContent loadFrom(InputStream stream) throws IOException {
        return this.loadFrom(new BufferedReader(new InputStreamReader(stream)));
    }

    protected PropertiesFileContent loadFrom(Reader reader) throws IOException {
        this.setProperties(new PropertiesFileContent());
        this.fileUtil().processTextLines(reader, (LineProcessor)this);
        return this.getProperties();
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }
}

