/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.PluginPathFinder;

public class BuildTimeSiteContentProvider
implements IPDEBuildConstants {
    private final String installedBaseURL;
    private final String[] urls;
    private final PDEUIStateWrapper pdeUIState;
    private BuildTimeSite site;
    private boolean filterP2Base = false;

    public BuildTimeSiteContentProvider(String[] urls, String installedBaseURL, PDEUIStateWrapper initialState) {
        this.installedBaseURL = installedBaseURL;
        this.urls = urls;
        this.pdeUIState = initialState;
    }

    public String getInstalledBaseURL() {
        return this.installedBaseURL;
    }

    public Collection getPluginPaths() {
        Collection pluginsToCompile = this.findPluginXML(Utils.asFile(this.urls));
        if (this.installedBaseURL != null) {
            pluginsToCompile.addAll(Arrays.asList(PluginPathFinder.getPluginPaths(this.installedBaseURL, this.filterP2Base)));
        }
        return pluginsToCompile;
    }

    public URL getURL() {
        throw new RuntimeException();
    }

    private Collection findPluginXML(File[] location) {
        ArrayList<File> collectedElements = new ArrayList<File>(10);
        int i = 0;
        while (i < location.length) {
            File f = new File(location[i], "plugins");
            if (f.exists()) {
                collectedElements.addAll(Arrays.asList(f.listFiles()));
            } else if (new File(location[i], "META-INF/MANIFEST.MF").exists() || new File(location[i], "plugin.xml").exists() || new File(location[i], "fragment.xml").exists()) {
                collectedElements.add(location[i]);
            } else if (location[i].isDirectory()) {
                collectedElements.addAll(Arrays.asList(location[i].listFiles()));
            } else if (location[i].isFile() && location[i].getName().endsWith(".jar")) {
                collectedElements.add(location[i]);
            }
            ++i;
        }
        return collectedElements;
    }

    public PDEUIStateWrapper getInitialState() {
        return this.pdeUIState;
    }

    public URL getArchiveReference(String id) {
        return null;
    }

    public BuildTimeSite getSite() {
        return this.site;
    }

    public void setSite(BuildTimeSite site) {
        this.site = site;
    }

    public void setFilterP2Base(boolean filter) {
        this.filterP2Base = filter;
    }
}

