/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.tree;

import java.awt.Component;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.Documentation;
import ptolemy.moml.EntityLibrary;
import ptolemy.vergil.icon.EditorIcon;
import ptolemy.vergil.icon.XMLIcon;

public class PtolemyTreeCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultTreeCellRenderer component = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof NamedObj) {
            NamedObj object = (NamedObj)value;
            if (!selected) {
                component.setBackground(tree.getBackground());
                component.setOpaque(true);
            } else {
                component.setOpaque(false);
            }
            if (object instanceof Settable) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(object.getName());
                buffer.append("=");
                buffer.append(((Settable)object).getExpression());
                component.setText(buffer.toString().replace('\n', ' '));
            } else {
                component.setText(object.getName());
            }
            if (!(object instanceof EntityLibrary)) {
                Attribute tooltipAttribute;
                List iconList = object.attributeList(EditorIcon.class);
                if (iconList.size() > 0 || object.getAttribute("_iconDescription") != null || object.getAttribute("_smallIconDescription") != null) {
                    EditorIcon icon = null;
                    try {
                        if (iconList.size() == 0) {
                            icon = new XMLIcon(object, "_icon");
                            icon.setPersistent(false);
                        } else {
                            icon = (EditorIcon)((Object)iconList.get(iconList.size() - 1));
                        }
                    }
                    catch (KernelException kernelException) {
                        throw new InternalErrorException("could not create icon in " + object + " even though one did not previously exist.");
                    }
                    try {
                        component.setIcon(icon.createIcon());
                    }
                    catch (Throwable throwable) {
                        System.err.println("Warning: Failed to create or set icon " + (Object)((Object)icon) + " for component " + component);
                        throwable.printStackTrace();
                    }
                }
                if ((tooltipAttribute = object.getAttribute("tooltip")) != null && tooltipAttribute instanceof Documentation) {
                    this.setToolTipText(((Documentation)tooltipAttribute).getValueAsString());
                } else {
                    String tip = Documentation.consolidate((NamedObj)object);
                    if (tip != null) {
                        this.setToolTipText(tip);
                    }
                }
            }
        }
        return component;
    }
}

