/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.canvas.interactor.PointConstraint;
import java.awt.geom.Point2D;

public class SnapConstraint
implements PointConstraint {
    private static double _defaultResolution = 5.0;
    private double _resolution = _defaultResolution;

    public void constrain(Point2D point) {
        double x = (double)Math.round(point.getX() / this._resolution) * this._resolution;
        double y = (double)Math.round(point.getY() / this._resolution) * this._resolution;
        point.setLocation(x, y);
    }

    public double[] constrain(double[] point) {
        double[] result = new double[]{(double)Math.round(point[0] / this._resolution) * this._resolution, (double)Math.round(point[1] / this._resolution) * this._resolution};
        return result;
    }

    public double[] constrain(double x, double y) {
        double[] result = new double[]{(double)Math.round(x / this._resolution) * this._resolution, (double)Math.round(y / this._resolution) * this._resolution};
        return result;
    }

    public static Point2D constrainPoint(Point2D point) {
        double[] originalPoint = new double[]{point.getX(), point.getY()};
        double[] result = SnapConstraint.constrainPoint(originalPoint);
        return new Point2D.Double(result[0], result[1]);
    }

    public static double[] constrainPoint(double[] point) {
        return SnapConstraint.constrainPoint(point[0], point[1]);
    }

    public static double[] constrainPoint(double x, double y) {
        double[] result = new double[]{(double)Math.round(x / _defaultResolution) * _defaultResolution, (double)Math.round(y / _defaultResolution) * _defaultResolution};
        return result;
    }

    public boolean snapped() {
        return true;
    }

    public void setResolution(double resolution) {
        this._resolution = resolution;
    }
}

