/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.kernel.attributes;

import java.awt.Color;
import java.awt.Shape;
import ptolemy.actor.gui.ColorAttribute;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.ResizableAttributeControllerFactory;
import ptolemy.vergil.kernel.attributes.ShapeAttribute;

public abstract class FilledShapeAttribute
extends ShapeAttribute {
    public Parameter centered;
    public ColorAttribute fillColor;
    public Parameter height;
    public Parameter width = new Parameter((NamedObj)this, "width");
    protected boolean _centeredValue = false;
    protected double _heightValue = 0.0;
    protected transient boolean _inAttributeChanged = false;
    protected double _widthValue = 0.0;

    public FilledShapeAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.width.setTypeEquals((Type)BaseType.DOUBLE);
        this.width.setExpression("100.0");
        this.height = new Parameter((NamedObj)this, "height");
        this.height.setTypeEquals((Type)BaseType.DOUBLE);
        this.height.setExpression("100.0");
        this.centered = new Parameter((NamedObj)this, "centered");
        this.centered.setTypeEquals((Type)BaseType.BOOLEAN);
        this.centered.setExpression("false");
        this.fillColor = new ColorAttribute((NamedObj)this, "fillColor");
        this.fillColor.setExpression("none");
        new ResizableAttributeControllerFactory((NamedObj)this, "_controllerFactory");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (!(attribute != this.width && attribute != this.height || this._inAttributeChanged)) {
            try {
                this._inAttributeChanged = true;
                double widthValue = ((DoubleToken)this.width.getToken()).doubleValue();
                double heightValue = ((DoubleToken)this.height.getToken()).doubleValue();
                if (widthValue == this._widthValue && heightValue == this._heightValue) return;
                this._widthValue = widthValue;
                this._heightValue = heightValue;
                this._icon.setShape(this._newShape());
                return;
            }
            finally {
                this._inAttributeChanged = false;
            }
        } else if (attribute == this.centered) {
            boolean centeredValue = ((BooleanToken)this.centered.getToken()).booleanValue();
            if (centeredValue == this._centeredValue) return;
            this._centeredValue = centeredValue;
            this._icon.setCentered(this._centeredValue);
            return;
        } else if (attribute == this.fillColor) {
            Color fillColorValue = this.fillColor.asColor();
            if ((float)fillColorValue.getAlpha() == 0.0f) {
                this._icon.setFillColor(null);
                return;
            } else {
                this._icon.setFillColor(fillColorValue);
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FilledShapeAttribute newObject = (FilledShapeAttribute)((Object)super.clone(workspace));
        newObject._inAttributeChanged = false;
        return newObject;
    }

    protected abstract Shape _newShape();
}

