/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.Figure;
import diva.canvas.toolbox.BasicRectangle;
import diva.canvas.toolbox.LabelFigure;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import ptolemy.data.IntToken;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.AttributeValueIcon;

public class UpdatedValueIcon
extends AttributeValueIcon {
    protected Settable _associatedAttribute;

    public UpdatedValueIcon(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.attributeName) {
            Attribute candidateAttribute;
            NamedObj container;
            if (this._associatedAttribute != null) {
                this._associatedAttribute.removeValueListener((ValueListener)this);
                this._associatedAttribute = null;
            }
            if ((container = this.getContainer()) != null && (candidateAttribute = container.getAttribute(this.attributeName.getExpression())) instanceof Settable) {
                this._associatedAttribute = (Settable)candidateAttribute;
                this._associatedAttribute.addValueListener((ValueListener)this);
            }
            this._updateFigures();
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        UpdatedValueIcon newObject = (UpdatedValueIcon)((Object)super.clone(workspace));
        newObject._associatedAttribute = null;
        try {
            newObject.attributeChanged((Attribute)newObject.attributeName);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return newObject;
    }

    public Figure createBackgroundFigure() {
        LabelFigure label = new LabelFigure("m", _labelFont, 1.0, 0);
        Rectangle2D stringBounds = label.getBounds();
        try {
            int numberOfCharacters = ((IntToken)this.displayWidth.getToken()).intValue();
            int width = (int)(stringBounds.getWidth() * (double)numberOfCharacters + 20.0);
            return new BasicRectangle(0.0, 0.0, (double)width, 30.0, (Paint)Color.white, 1.0f);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public void valueChanged(Settable settable) {
        if (settable == this._associatedAttribute) {
            this._updateFigures();
        } else {
            super.valueChanged(settable);
        }
    }

    protected void _updateFigures() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = UpdatedValueIcon.this._displayString();
                Iterator figures = UpdatedValueIcon.this._liveFigureIterator();
                while (figures.hasNext()) {
                    LabelFigure figure = (LabelFigure)figures.next();
                    figure.setString(string);
                }
            }
        });
    }
}

