/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.icon;

import diva.canvas.Figure;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.icon.EditorIcon;

public class DynamicEditorIcon
extends EditorIcon {
    private List _figures = new LinkedList();

    public DynamicEditorIcon(Workspace workspace, String name) throws IllegalActionException {
        super(workspace, name);
    }

    public DynamicEditorIcon(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        DynamicEditorIcon newObject = (DynamicEditorIcon)((Object)super.clone(workspace));
        newObject._figures = new LinkedList();
        return newObject;
    }

    protected void _addLiveFigure(Figure newFigure) {
        this._figures.add(new WeakReference<Figure>(newFigure));
        this._trimLiveFigures();
    }

    protected Iterator _liveFigureIterator() {
        final ListIterator iterator = this._figures.listIterator();
        return new Iterator(){
            private Object _object;

            public boolean hasNext() {
                while (this._object == null && iterator.hasNext()) {
                    this._object = ((WeakReference)iterator.next()).get();
                    if (this._object != null) continue;
                    iterator.remove();
                }
                return this._object != null;
            }

            public Object next() throws NoSuchElementException {
                while (this._object == null && iterator.hasNext()) {
                    this._object = ((WeakReference)iterator.next()).get();
                    if (this._object != null) continue;
                    iterator.remove();
                }
                if (this._object == null) {
                    throw new NoSuchElementException("The iterator is empty.");
                }
                Object object = this._object;
                this._object = null;
                return object;
            }

            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("The remove() operation is unsupported.");
            }
        };
    }

    protected void _trimLiveFigures() {
        ListIterator figures = this._figures.listIterator();
        while (figures.hasNext()) {
            Object figure = ((WeakReference)figures.next()).get();
            if (figure != null) continue;
            figures.remove();
        }
    }
}

