/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm.modal;

import diva.graph.GraphController;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedActor;
import ptolemy.actor.gui.Configuration;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.domains.fsm.modal.ModalController;
import ptolemy.domains.fsm.modal.Refinement;
import ptolemy.domains.fsm.modal.RefinementPort;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.fsm.FSMGraphController;
import ptolemy.vergil.fsm.StateController;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;

public class HierarchicalStateController
extends StateController {
    public HierarchicalStateController(GraphController controller) {
        this(controller, FULL);
    }

    public HierarchicalStateController(GraphController controller, AttributeController.Access access) {
        super(controller, access);
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(new AddRefinementAction()));
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(new RemoveRefinementAction()));
    }

    private class AddRefinementAction
    extends FigureAction {
        public AddRefinementAction() {
            super("Add Refinement");
        }

        public void actionPerformed(ActionEvent e) {
            String moml;
            super.actionPerformed(e);
            NamedObj target = this.getTarget();
            if (!(target instanceof State)) {
                MessageHandler.error((String)"Can only add refinements to states.");
                return;
            }
            State state = (State)target;
            NamedObj immediateContainer = state.getContainer();
            if (immediateContainer == null) {
                MessageHandler.error((String)"State has no container!");
                return;
            }
            final CompositeEntity container = (CompositeEntity)immediateContainer.getContainer();
            if (container == null) {
                MessageHandler.error((String)"State container has no container!");
                return;
            }
            Query query = new Query();
            String defaultName = container.uniqueName(state.getName());
            query.addLine("Name", "Name", defaultName);
            Configuration configuration = ((FSMGraphController)HierarchicalStateController.this.getController()).getConfiguration();
            ComponentEntity refinements = configuration.getEntity("_stateRefinements");
            String[] choiceClasses = new String[]{"ptolemy.domains.fsm.modal.Refinement", "ptolemy.domains.fsm.modal.ModalController"};
            String[] choiceNames = new String[]{"Default Refinement", "State Machine Refinement"};
            if (refinements instanceof CompositeEntity) {
                List refinementList = ((CompositeEntity)refinements).entityList();
                choiceNames = new String[refinementList.size()];
                choiceClasses = new String[refinementList.size()];
                Iterator iterator = refinementList.iterator();
                int count = 0;
                while (iterator.hasNext()) {
                    Entity entity = (Entity)iterator.next();
                    choiceNames[count] = entity.getName();
                    choiceClasses[count++] = entity.getClass().getName();
                }
            }
            query.addChoice("Class", "Class", choiceNames, choiceNames[0], true);
            ComponentDialog dialog = new ComponentDialog(null, "Specify Refinement", query);
            if (!dialog.buttonPressed().equals("OK")) {
                return;
            }
            final String newName = query.getStringValue("Name");
            if (container.getEntity(newName) != null) {
                MessageHandler.error((String)("There is already a refinement with name " + newName + "."));
                return;
            }
            int choiceIndex = query.getIntValue("Class");
            String newClass = choiceClasses[choiceIndex];
            String currentRefinements = state.refinementName.getExpression();
            currentRefinements = currentRefinements == null || currentRefinements.equals("") ? newName : String.valueOf(currentRefinements.trim()) + ", " + newName;
            if (refinements instanceof CompositeEntity) {
                String choiceName = choiceNames[choiceIndex];
                ComponentEntity template = ((CompositeEntity)refinements).getEntity(choiceName);
                String templateDescription = template.exportMoML(newName);
                moml = "<group>" + templateDescription + "<entity name=\"" + state.getName((NamedObj)container) + "\"><property name=\"refinementName\" value=\"" + currentRefinements + "\"/></entity></group>";
            } else {
                moml = "<group><entity name=\"" + newName + "\" class=\"" + newClass + "\"/>" + "<entity name=\"" + state.getName((NamedObj)container) + "\"><property name=\"refinementName\" value=\"" + currentRefinements + "\"/></entity></group>";
            }
            MoMLChangeRequest change = new MoMLChangeRequest(this, (NamedObj)container, moml){

                protected void _execute() throws Exception {
                    super._execute();
                    ComponentEntity entity = container.getEntity(newName);
                    for (Port port : container.portList()) {
                        try {
                            if (entity instanceof Refinement) {
                                ((Refinement)entity).setMirrorDisable(true);
                            } else if (entity instanceof ModalController) {
                                ((ModalController)entity).setMirrorDisable(true);
                            }
                            Port newPort = entity.newPort(port.getName());
                            if (!(newPort instanceof RefinementPort) || !(port instanceof IOPort)) continue;
                            try {
                                ((RefinementPort)newPort).setMirrorDisable(true);
                                if (((IOPort)port).isInput()) {
                                    ((RefinementPort)newPort).setInput(true);
                                }
                                if (((IOPort)port).isOutput()) {
                                    ((RefinementPort)newPort).setOutput(true);
                                }
                                if (!((IOPort)port).isMultiport()) continue;
                                ((RefinementPort)newPort).setMultiport(true);
                            }
                            finally {
                                ((RefinementPort)newPort).setMirrorDisable(false);
                            }
                        }
                        finally {
                            if (entity instanceof Refinement) {
                                ((Refinement)entity).setMirrorDisable(false);
                            } else if (entity instanceof ModalController) {
                                ((ModalController)entity).setMirrorDisable(false);
                            }
                        }
                    }
                    if (HierarchicalStateController.this._configuration != null) {
                        HierarchicalStateController.this._configuration.openModel((NamedObj)entity);
                    }
                }
            };
            container.requestChange((ChangeRequest)change);
        }
    }

    private static class RemoveRefinementAction
    extends FigureAction {
        public RemoveRefinementAction() {
            super("Remove Refinement");
        }

        public void actionPerformed(ActionEvent e) {
            TypedActor[] refinements;
            super.actionPerformed(e);
            NamedObj target = this.getTarget();
            if (!(target instanceof State)) {
                MessageHandler.error((String)"Can only remove refinements from states.");
                return;
            }
            State state = (State)target;
            CompositeEntity immediateContainer = (CompositeEntity)state.getContainer();
            if (immediateContainer == null) {
                MessageHandler.error((String)"State has no container!");
                return;
            }
            CompositeEntity container = (CompositeEntity)immediateContainer.getContainer();
            if (container == null) {
                MessageHandler.error((String)"State container has no container!");
                return;
            }
            try {
                refinements = state.getRefinement();
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Invalid refinements.", (Throwable)ex);
                return;
            }
            if (refinements == null || refinements.length < 1) {
                MessageHandler.error((String)"No refinements to remove.");
                return;
            }
            String[] choices = new String[refinements.length];
            int i = 0;
            while (i < refinements.length) {
                choices[i] = refinements[i].getName();
                ++i;
            }
            Query query = new Query();
            query.addChoice("Refinement", "Refinement", choices, choices[0], false);
            ComponentDialog dialog = new ComponentDialog(null, "Specify Refinement", query);
            if (!dialog.buttonPressed().equals("OK")) {
                return;
            }
            String refinementName = query.getStringValue("Refinement");
            StringBuffer newRefinements = new StringBuffer();
            String currentRefinements = state.refinementName.getExpression();
            StringTokenizer tokenizer = new StringTokenizer(currentRefinements, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.trim().equals(refinementName)) continue;
                if (newRefinements.length() > 0) {
                    newRefinements.append(", ");
                }
                newRefinements.append(token.trim());
            }
            Iterator states = immediateContainer.entityList().iterator();
            boolean foundOne = false;
            while (states.hasNext()) {
                String refinementList;
                NamedObj other = (NamedObj)states.next();
                if (other == state || !(other instanceof State) || (refinementList = ((State)other).refinementName.getExpression()) == null) continue;
                tokenizer = new StringTokenizer(refinementList, ",");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!token.equals(refinementName)) continue;
                    foundOne = true;
                    break;
                }
                if (foundOne) break;
            }
            if (!foundOne) {
                for (NamedObj other : immediateContainer.relationList()) {
                    String refinementList;
                    if (!(other instanceof Transition) || (refinementList = ((Transition)other).refinementName.getExpression()) == null) continue;
                    tokenizer = new StringTokenizer(refinementList, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (!token.equals(refinementName)) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) break;
                }
            }
            String removal = "";
            if (!foundOne) {
                removal = "<deleteEntity name=\"" + refinementName + "\"/>";
            }
            String moml = "<group><entity name=\"" + state.getName((NamedObj)container) + "\"><property name=\"refinementName\" value=\"" + newRefinements.toString() + "\"/></entity>" + removal + "</group>";
            MoMLChangeRequest change = new MoMLChangeRequest((Object)this, (NamedObj)container, moml);
            container.requestChange((ChangeRequest)change);
        }
    }
}

