/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.fsm;

import diva.canvas.CanvasLayer;
import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.interactor.CompositeInteractor;
import diva.canvas.interactor.GrabHandle;
import diva.canvas.interactor.Interactor;
import diva.graph.GraphController;
import diva.graph.GraphException;
import diva.graph.GraphPane;
import diva.gui.GUIUtilities;
import diva.gui.toolbox.FigureIcon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import ptolemy.actor.gui.Configuration;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.LibraryAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.MessageHandler;
import ptolemy.vergil.actor.ExternalIOPortController;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.basic.WithIconGraphController;
import ptolemy.vergil.fsm.Arc;
import ptolemy.vergil.fsm.FSMGraphModel;
import ptolemy.vergil.fsm.FSMViewerGraphController;
import ptolemy.vergil.fsm.StateController;
import ptolemy.vergil.fsm.TransitionController;
import ptolemy.vergil.fsm.modal.ModalTransitionController;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.kernel.ConfigureUnitsAction;
import ptolemy.vergil.kernel.PortDialogAction;
import ptolemy.vergil.toolbox.FigureAction;

public class FSMGraphController
extends FSMViewerGraphController {
    private ConfigureUnitsAction _configureUnitsAction;
    private LinkCreator _linkCreator;
    private NewStateAction _newStateAction = new NewStateAction();
    private MouseFilter _shortcutFilter = new MouseFilter(16, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private Action _newInputPortAction = new WithIconGraphController.NewPortAction(ExternalIOPortController._GENERIC_INPUT, "New input port", 73, new String[][]{{"/ptolemy/vergil/actor/img/single_in.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/single_in_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/single_in_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/single_in_on.gif", "selectedIcon"}});
    private Action _newOutputPortAction = new WithIconGraphController.NewPortAction(ExternalIOPortController._GENERIC_OUTPUT, "New output port", 79, new String[][]{{"/ptolemy/vergil/actor/img/single_out.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/single_out_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/single_out_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/single_out_on.gif", "selectedIcon"}});
    private Action _newInOutPortAction = new WithIconGraphController.NewPortAction(ExternalIOPortController._GENERIC_INOUT, "New input/output port", 80, new String[][]{{"/ptolemy/vergil/actor/img/single_inout.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/single_inout_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/single_inout_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/single_inout_on.gif", "selectedIcon"}});
    private Action _newInputMultiportAction = new WithIconGraphController.NewPortAction(ExternalIOPortController._GENERIC_INPUT_MULTIPORT, "New input multiport", 78, new String[][]{{"/ptolemy/vergil/actor/img/multi_in.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/multi_in_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/multi_in_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/multi_in_on.gif", "selectedIcon"}});
    private Action _newOutputMultiportAction = new WithIconGraphController.NewPortAction(ExternalIOPortController._GENERIC_OUTPUT_MULTIPORT, "New output multiport", 85, new String[][]{{"/ptolemy/vergil/actor/img/multi_out.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/multi_out_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/multi_out_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/multi_out_on.gif", "selectedIcon"}});
    private Action _newInOutMultiportAction = new WithIconGraphController.NewPortAction(ExternalIOPortController._GENERIC_INOUT_MULTIPORT, "New input/output multiport", 84, new String[][]{{"/ptolemy/vergil/actor/img/multi_inout.gif", "LargeIcon"}, {"/ptolemy/vergil/actor/img/multi_inout_o.gif", "rolloverIcon"}, {"/ptolemy/vergil/actor/img/multi_inout_ov.gif", "rolloverSelectedIcon"}, {"/ptolemy/vergil/actor/img/multi_inout_on.gif", "selectedIcon"}});
    private PortDialogAction _portDialogAction;
    private static Location _prototypeState;

    static {
        CompositeEntity container = new CompositeEntity();
        try {
            State state = new State(container, "S");
            _prototypeState = new Location((NamedObj)state, "_location");
        }
        catch (KernelException ex) {
            throw new InternalErrorException(null, (Throwable)ex, null);
        }
    }

    public void addToMenuAndToolbar(JMenu menu, JToolBar toolbar) {
        super.addToMenuAndToolbar(menu, toolbar);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInputPortAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInputPortAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newOutputPortAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newOutputPortAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInOutPortAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInOutPortAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInputMultiportAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInputMultiportAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newOutputMultiportAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newOutputMultiportAction);
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newInOutMultiportAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newInOutMultiportAction);
        menu.addSeparator();
        GUIUtilities.addMenuItem((JMenu)menu, (Action)this._newStateAction);
        GUIUtilities.addToolBarButton((JToolBar)toolbar, (Action)this._newStateAction);
    }

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        if (this._portDialogAction != null) {
            this._portDialogAction.setConfiguration(configuration);
        }
        if (this._configureUnitsAction != null) {
            this._configureUnitsAction.setConfiguration(configuration);
        }
    }

    protected void _createControllers() {
        this._attributeController = new AttributeController((GraphController)this, AttributeController.FULL);
        this._portController = new ExternalIOPortController((GraphController)this, AttributeController.FULL);
        this._stateController = new StateController((GraphController)this, AttributeController.FULL);
        this._modalTransitionController = new ModalTransitionController((GraphController)this);
        this._transitionController = new TransitionController((GraphController)this);
    }

    protected void initializeInteraction() {
        super.initializeInteraction();
        this.getGraphPane();
        this._portDialogAction = new PortDialogAction("Ports");
        this._portDialogAction.setConfiguration(this.getConfiguration());
        _configureMenuFactory.addAction(this._portDialogAction, "Customize");
        this._configureUnitsAction = new ConfigureUnitsAction("Units Constraints");
        _configureMenuFactory.addAction(this._configureUnitsAction, "Customize");
        this._configureUnitsAction.setConfiguration(this.getConfiguration());
        this._linkCreator = new LinkCreator();
        this._linkCreator.setMouseFilter(this._shortcutFilter);
        ((CompositeInteractor)this._stateController.getNodeInteractor()).addInteractor((Interactor)this._linkCreator);
    }

    protected void _initializeInteraction(NamedObjController controller) {
        Interactor interactor;
        super._initializeInteraction(controller);
        if (controller instanceof StateController && (interactor = controller.getNodeInteractor()) instanceof CompositeInteractor) {
            ((CompositeInteractor)interactor).addInteractor((Interactor)this._linkCreator);
        }
    }

    protected class LinkCreator
    extends AbstractInteractor {
        protected LinkCreator() {
        }

        public void mousePressed(LayerEvent event) {
            Figure source = event.getFigureSource();
            NamedObj sourceObject = (NamedObj)source.getUserObject();
            Arc link = new Arc();
            FSMGraphModel model = (FSMGraphModel)FSMGraphController.this.getGraphModel();
            model.getArcModel().setTail(link, sourceObject);
            try {
                FigureLayer layer = FSMGraphController.this.getGraphPane().getForegroundLayer();
                AutonomousSite headSite = new AutonomousSite((CanvasLayer)layer, event.getLayerX(), event.getLayerY());
                AutonomousSite tailSite = new AutonomousSite((CanvasLayer)layer, event.getLayerX(), event.getLayerY());
                Connector c = FSMGraphController.this.getEdgeController(link).render((Object)link, layer, (Site)tailSite, (Site)headSite);
                tailSite = FSMGraphController.this.getEdgeController(link).getConnectorTarget().getTailSite(c, source, event.getLayerX(), event.getLayerY());
                if (tailSite == null) {
                    throw new RuntimeException("Invalid connector target: no valid site found for tail of new connector.");
                }
                c.setTailSite((Site)tailSite);
                Figure ef = FSMGraphController.this.getFigure(link);
                FSMGraphController.this.getSelectionModel().addSelection((Object)ef);
                ConnectorManipulator cm = (ConnectorManipulator)ef.getParent();
                GrabHandle gh = cm.getHeadHandle();
                layer.grabPointer(event, (Figure)gh);
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Drag connection failed:", (Throwable)ex);
            }
        }
    }

    public class NewStateAction
    extends FigureAction {
        public NewStateAction() {
            super("New State");
            this.putValue("tooltip", "New State");
            StateController.StateRenderer renderer = new StateController.StateRenderer(FSMGraphController.this.getGraphModel());
            Figure figure = renderer.render(_prototypeState);
            FigureIcon icon = new FigureIcon(figure, 25, 25, 1, true);
            this.putValue("LargeIcon", icon);
            this.putValue("tooltip", "New State");
            this.putValue("MnemonicKey", 87);
        }

        public void actionPerformed(ActionEvent e) {
            double y;
            double x;
            super.actionPerformed(e);
            if (this.getSourceType() == TOOLBAR_TYPE || this.getSourceType() == MENUBAR_TYPE) {
                Point2D center;
                BasicGraphFrame frame = FSMGraphController.this.getFrame();
                if (frame != null) {
                    center = frame.getCenter();
                    x = center.getX();
                    y = center.getY();
                } else {
                    GraphPane pane = FSMGraphController.this.getGraphPane();
                    center = pane.getSize();
                    x = center.getX() / 2.0;
                    y = center.getY() / 2.0;
                }
            } else {
                x = this.getX();
                y = this.getY();
            }
            FSMGraphModel graphModel = (FSMGraphModel)FSMGraphController.this.getGraphModel();
            NamedObj toplevel = graphModel.getPtolemyModel();
            String stateName = toplevel.uniqueName("state");
            String moml = null;
            String locationName = "_location";
            try {
                CompositeEntity library;
                ComponentEntity prototype;
                LibraryAttribute attribute = (LibraryAttribute)toplevel.getAttribute("_library", LibraryAttribute.class);
                if (attribute != null && (prototype = (library = attribute.getLibrary()).getEntity("state")) != null) {
                    moml = prototype.exportMoML(stateName);
                }
            }
            catch (Exception exception) {}
            if (moml == null) {
                moml = "<entity name=\"" + stateName + "\" class=\"ptolemy.domains.fsm.kernel.State\">\n" + "<property name=\"" + locationName + "\" class=\"ptolemy.kernel.util.Location\"" + " value=\"[" + x + ", " + y + "]\"/>\n" + "</entity>\n";
            }
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, toplevel, moml);
            toplevel.requestChange((ChangeRequest)request);
            try {
                request.waitForCompletion();
            }
            catch (Exception ex) {
                throw new GraphException(ex);
            }
        }
    }
}

