/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.debugger;

import diva.canvas.Figure;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import ptolemy.actor.Actor;
import ptolemy.actor.Executable;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.Manager;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.SingletonConfigurableAttribute;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.debugger.DebugProfile;
import ptolemy.vergil.kernel.DebugRenderer;

public class DebugController
extends SingletonConfigurableAttribute {
    private DebugRenderer _debugRenderer = null;
    private Hashtable _toDebug = new Hashtable();

    public DebugController(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setPersistent(false);
    }

    public void clear() {
        this._toDebug.clear();
    }

    public void event(DebugEvent debugEvent) {
        FiringEvent event;
        NamedObj objToHighlight;
        if (debugEvent instanceof FiringEvent && this._toDebug.containsKey(objToHighlight = (NamedObj)(event = (FiringEvent)debugEvent).getActor())) {
            Figure figure;
            DebugProfile debugProfile = this.getDebugProfile((Executable)objToHighlight);
            BasicGraphController graphController = debugProfile.getGraphController();
            AbstractBasicGraphModel graphModel = (AbstractBasicGraphModel)graphController.getGraphModel();
            NamedObj toplevel = graphModel.getPtolemyModel();
            while (objToHighlight != null && objToHighlight.getContainer() != toplevel) {
                objToHighlight = objToHighlight.getContainer();
            }
            if (objToHighlight == null) {
                return;
            }
            Attribute location = objToHighlight.getAttribute("_location");
            if (location != null && (figure = graphController.getFigure(location)) != null && debugProfile.isListening(event.getType())) {
                String message = String.valueOf(objToHighlight.getName()) + " " + event.getType().getName();
                Manager manager = ((Actor)objToHighlight).getManager();
                this.render(figure, manager, message);
            }
        }
    }

    public DebugProfile getDebugProfile(Executable actor) {
        return (DebugProfile)this._toDebug.get(actor);
    }

    public boolean isEnabled() {
        return false;
    }

    public void message(String string) {
    }

    public void putDebugProfile(Executable actor, DebugProfile profile) {
        this._toDebug.put(actor, profile);
    }

    public void removeDebugProfile(Executable actor) {
        this._toDebug.remove(actor);
    }

    public void setEnabled(boolean enabled) {
    }

    private void render(final Figure figure, Manager manager, String message) {
        if (this._debugRenderer == null) {
            this._debugRenderer = new DebugRenderer();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugController.this._debugRenderer.renderSelected(figure);
            }
        });
        final Figure debugRendered = figure;
        manager.pauseOnBreakpoint(message);
        if (debugRendered != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebugController.this._debugRenderer.renderDeselected(debugRendered);
                }
            });
        }
    }
}

