/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import diva.canvas.Figure;
import diva.graph.GraphController;
import diva.graph.GraphException;
import diva.graph.GraphPane;
import diva.graph.NodeRenderer;
import diva.gui.GUIUtilities;
import diva.gui.toolbox.FigureIcon;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Action;
import ptolemy.actor.IOPort;
import ptolemy.actor.gui.Configuration;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.actor.ExternalIOPortController;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.BasicGraphController;
import ptolemy.vergil.basic.BasicGraphFrame;
import ptolemy.vergil.basic.NamedObjController;
import ptolemy.vergil.kernel.AttributeController;
import ptolemy.vergil.toolbox.EditIconAction;
import ptolemy.vergil.toolbox.FigureAction;
import ptolemy.vergil.toolbox.MenuActionFactory;
import ptolemy.vergil.toolbox.RemoveIconAction;
import ptolemy.vergil.toolbox.SnapConstraint;

public abstract class WithIconGraphController
extends BasicGraphController {
    protected static EditIconAction _editIconAction = new EditIconAction();
    protected NamedObjController _portController;
    protected static RemoveIconAction _removeIconAction = new RemoveIconAction();
    private static double _PORT_OFFSET = 20.0;

    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._portController.setConfiguration(configuration);
        _editIconAction.setConfiguration(configuration);
        _removeIconAction.setConfiguration(configuration);
    }

    protected void _createControllers() {
        super._createControllers();
        this._portController = new ExternalIOPortController((GraphController)this, AttributeController.PARTIAL);
    }

    protected void initializeInteraction() {
        super.initializeInteraction();
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(_editIconAction));
        this._menuFactory.addMenuItemFactory(new MenuActionFactory(_removeIconAction));
    }

    public class NewPortAction
    extends FigureAction {
        private IOPort _prototype;

        public NewPortAction(IOPort prototype, String description, int mnemonicKey) {
            this(prototype, description, mnemonicKey, null);
        }

        public NewPortAction(IOPort prototype, String description, int mnemonicKey, String[][] iconRoles) {
            super(description);
            this._prototype = prototype;
            if (iconRoles != null) {
                GUIUtilities.addIcons((Action)this, (String[][])iconRoles);
            } else {
                NodeRenderer renderer = WithIconGraphController.this._portController.getNodeRenderer();
                Attribute location = null;
                if (this._prototype != null) {
                    location = this._prototype.getAttribute("_location");
                }
                Figure figure = renderer.render(location);
                FigureIcon icon = new FigureIcon(figure, 25, 25, 1, true);
                this.putValue("LargeIcon", icon);
            }
            this.putValue("tooltip", description);
            this.putValue("MnemonicKey", mnemonicKey);
        }

        public void actionPerformed(ActionEvent e) {
            double y;
            double x;
            super.actionPerformed(e);
            if (this.getSourceType() == TOOLBAR_TYPE || this.getSourceType() == MENUBAR_TYPE) {
                BasicGraphFrame frame = WithIconGraphController.this.getFrame();
                if (frame != null) {
                    Point2D center = frame.getCenter();
                    if (this._prototype != null) {
                        Rectangle2D visiblePart = frame.getVisibleRectangle();
                        if (this._prototype.isInput() && this._prototype.isOutput()) {
                            x = center.getX();
                            y = visiblePart.getY() + visiblePart.getHeight() - _PORT_OFFSET;
                        } else if (this._prototype.isInput()) {
                            x = visiblePart.getX() + _PORT_OFFSET;
                            y = center.getY();
                        } else if (this._prototype.isOutput()) {
                            x = visiblePart.getX() + visiblePart.getWidth() - _PORT_OFFSET;
                            y = center.getY();
                        } else {
                            x = center.getX();
                            y = center.getY();
                        }
                    } else {
                        x = center.getX();
                        y = center.getY();
                    }
                } else {
                    GraphPane pane = WithIconGraphController.this.getGraphPane();
                    Point2D center = pane.getSize();
                    x = center.getX() / 2.0;
                    y = center.getY() / 2.0;
                }
            } else {
                AffineTransform inverse;
                AffineTransform current = WithIconGraphController.this.getGraphPane().getTransformContext().getTransform();
                try {
                    inverse = current.createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    throw new RuntimeException(ex.toString());
                }
                Point2D.Double point = new Point2D.Double(this.getX(), this.getY());
                inverse.transform(point, point);
                x = ((Point2D)point).getX();
                y = ((Point2D)point).getY();
            }
            AbstractBasicGraphModel graphModel = (AbstractBasicGraphModel)WithIconGraphController.this.getGraphModel();
            final double[] point = SnapConstraint.constrainPoint(x, y);
            final NamedObj toplevel = graphModel.getPtolemyModel();
            if (!(toplevel instanceof Entity)) {
                throw new InternalErrorException("Cannot invoke NewPortAction on an object that is not an instance of Entity.");
            }
            final String portName = toplevel.uniqueName("port");
            StringBuffer moml = new StringBuffer();
            moml.append("<port name=\"" + portName + "\">\n");
            moml.append("<property name=\"_location\" class=\"ptolemy.kernel.util.Location\"/>\n");
            if (this._prototype != null) {
                if (this._prototype.isInput()) {
                    moml.append("<property name=\"input\"/>");
                }
                if (this._prototype.isOutput()) {
                    moml.append("<property name=\"output\"/>");
                }
                if (this._prototype.isMultiport()) {
                    moml.append("<property name=\"width\" class=\"ptolemy.data.expr.Parameter\" value=\"0\"/>");
                    moml.append("<property name=\"multiport\"/>");
                }
            }
            moml.append("</port>");
            MoMLChangeRequest request = new MoMLChangeRequest(this, toplevel, moml.toString()){

                protected void _execute() throws Exception {
                    super._execute();
                    Port newObject = ((Entity)toplevel).getPort(portName);
                    Location location = (Location)newObject.getAttribute("_location");
                    location.setLocation(point);
                }
            };
            request.setUndoable(true);
            toplevel.requestChange((ChangeRequest)request);
            try {
                request.waitForCompletion();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new GraphException(ex);
            }
        }
    }
}

