/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.Configurable;
import ptolemy.kernel.util.ConfigurableAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.vergil.basic.DocAttribute;

public class KeplerDocumentationAttribute
extends Attribute
implements Configurable {
    private String source;
    private String text;
    private String docName;
    private String docClass;
    private String description;
    private String author;
    private String version;
    private String userLevelDocumentation;
    private Hashtable portHash = new Hashtable();
    private Hashtable propertyHash = new Hashtable();

    public KeplerDocumentationAttribute() {
    }

    public KeplerDocumentationAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public KeplerDocumentationAttribute(Workspace workspace) {
        super(workspace);
    }

    public void createInstanceFromExisting(KeplerDocumentationAttribute da) {
        for (ConfigurableAttribute att : da.attributeList()) {
            String attName = att.getName();
            if (attName.equals("description")) {
                this.description = att.getConfigureText();
                continue;
            }
            if (attName.equals("author")) {
                this.author = att.getConfigureText();
                continue;
            }
            if (attName.equals("version")) {
                this.version = att.getConfigureText();
                continue;
            }
            if (attName.equals("userLevelDocumentation")) {
                this.userLevelDocumentation = att.getConfigureText();
                continue;
            }
            if (attName.indexOf("port:") != -1) {
                String portName = attName.substring(attName.indexOf(":") + 1, attName.length());
                String portDesc = att.getConfigureText();
                if (portName == null) continue;
                if (portDesc == null) {
                    portDesc = "";
                }
                this.portHash.put(portName, portDesc);
                continue;
            }
            if (attName.indexOf("prop:") == -1) continue;
            String propName = attName.substring(attName.indexOf(":") + 1, attName.length());
            String propDesc = att.getConfigureText();
            if (propName == null) continue;
            if (propDesc == null) {
                propDesc = "";
            }
            this.propertyHash.put(propName, propDesc);
        }
    }

    public void createEmptyFields(NamedObj target) {
        try {
            new ConfigurableAttribute((NamedObj)this, "author");
            new ConfigurableAttribute((NamedObj)this, "version");
            new ConfigurableAttribute((NamedObj)this, "description");
            new ConfigurableAttribute((NamedObj)this, "userLevelDocumentation");
            this.author = "";
            this.version = "";
            this.description = "";
            this.userLevelDocumentation = "";
            for (Attribute a : target.attributeList()) {
                String aname = a.getName();
                if (aname.substring(0, 1).equals("_") || aname.equals("KeplerDocumentation")) continue;
                this.propertyHash.put(a.getName(), "");
            }
            if (target instanceof Entity) {
                for (Port p : ((Entity)target).portList()) {
                    this.portHash.put(p.getName(), "");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Could not add KeplerDocumentation internal attributes: " + e.getMessage());
        }
    }

    public void exportMoML(Writer output, int depth, String name) throws IOException {
        this.createInstanceFromExisting(this);
        StringBuffer sb = new StringBuffer();
        sb.append("<property name=\"" + name + "\" class=\"" + this.getClassName());
        sb.append("\">\n");
        sb.append("<property name=\"description\" class=\"ptolemy.kernel.util.ConfigurableAttribute\">");
        sb.append("<configure>" + this.description + "</configure>");
        sb.append("</property>\n");
        sb.append("<property name=\"author\" class=\"ptolemy.kernel.util.ConfigurableAttribute\">");
        sb.append("<configure>" + this.author + "</configure>");
        sb.append("</property>\n");
        sb.append("<property name=\"version\" class=\"ptolemy.kernel.util.ConfigurableAttribute\">");
        sb.append("<configure>" + this.version + "</configure>");
        sb.append("</property>\n");
        sb.append("<property name=\"userLevelDocumentation\" class=\"ptolemy.kernel.util.ConfigurableAttribute\">");
        sb.append("<configure>" + this.userLevelDocumentation + "</configure>");
        sb.append("</property>\n");
        Enumeration portKeys = this.portHash.keys();
        while (portKeys.hasMoreElements()) {
            String key = (String)portKeys.nextElement();
            String val = (String)this.portHash.get(key);
            sb.append("<property name=\"port:" + key + "\" class=\"ptolemy.kernel.util.ConfigurableAttribute\">");
            sb.append("<configure>" + val + "</configure>");
            sb.append("</property>\n");
        }
        Enumeration propKeys = this.propertyHash.keys();
        while (propKeys.hasMoreElements()) {
            String key = (String)propKeys.nextElement();
            String val = (String)this.propertyHash.get(key);
            sb.append("<property name=\"prop:" + key + "\" class=\"ptolemy.kernel.util.ConfigurableAttribute\">");
            sb.append("<configure>" + val + "</configure>");
            sb.append("</property>\n");
        }
        sb.append("</property>");
        output.write(sb.toString());
    }

    public String toDocML() {
        this.createInstanceFromExisting(this);
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        sb.append("<!DOCTYPE doc PUBLIC \"-//UC Berkeley//DTD DocML 1//EN\"");
        sb.append("\"http://ptolemy.eecs.berkeley.edu/xml/dtd/DocML_1.dtd\">\n");
        sb.append("<doc name=\"" + this.docName + "\" class=\"" + this.docClass + "\">\n");
        sb.append("<description>\n" + this.userLevelDocumentation + "\n</description>\n");
        sb.append("<author>" + this.author + "</author>\n");
        Enumeration portItt = this.portHash.keys();
        while (portItt.hasMoreElements()) {
            String name = (String)portItt.nextElement();
            String desc = (String)this.portHash.get(name);
            sb.append("<port name=\"" + name + "\">");
            sb.append(desc).append("</port>\n");
        }
        Enumeration propItt = this.propertyHash.keys();
        while (propItt.hasMoreElements()) {
            String name = (String)propItt.nextElement();
            String desc = (String)this.propertyHash.get(name);
            sb.append("<property name=\"" + name + "\">");
            sb.append(desc).append("</property>\n");
        }
        sb.append("</doc>\n");
        return sb.toString();
    }

    public DocAttribute getDocAttribute(NamedObj target) {
        this.createInstanceFromExisting(this);
        try {
            DocAttribute da = new DocAttribute(target.workspace());
            da.setContainer(target);
            da.author = new StringAttribute((NamedObj)da, "author");
            da.author.setExpression(this.author);
            da.version = new StringAttribute((NamedObj)da, "version");
            da.version.setExpression(this.version);
            da.since = new StringAttribute((NamedObj)da, "since");
            da.since.setExpression("");
            da.description = new StringParameter((NamedObj)da, "description");
            da.description.setExpression(this.userLevelDocumentation);
            Enumeration portItt = this.portHash.keys();
            while (portItt.hasMoreElements()) {
                String name = (String)portItt.nextElement();
                String desc = (String)this.portHash.get(name);
                StringAttribute sa = new StringAttribute((NamedObj)da, String.valueOf(name) + " (port)");
                sa.setExpression(desc);
            }
            Enumeration propItt = this.propertyHash.keys();
            while (propItt.hasMoreElements()) {
                String name = (String)propItt.nextElement();
                String desc = (String)this.propertyHash.get(name);
                StringParameter sp = new StringParameter((NamedObj)da, String.valueOf(name) + " (parameter)");
                sp.setExpression(desc);
            }
            return da;
        }
        catch (Exception e) {
            System.out.println("Error creating docAttribute: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void updateContent() throws InternalErrorException {
    }

    public void setDocName(String name) {
        this.docName = name;
    }

    public String getDocName() {
        if (!this.docName.equals("null")) {
            return this.docName;
        }
        return "";
    }

    public void setDocClass(String className) {
        this.docClass = className;
    }

    public String getDocClass() {
        if (!this.docClass.equals("null")) {
            return this.docClass;
        }
        return "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        if (!this.description.equals("null")) {
            return this.description;
        }
        return "";
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        if (this.author == null) {
            return "";
        }
        if (!this.author.equals("null")) {
            return this.author;
        }
        return "";
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        if (this.version == null) {
            return "";
        }
        if (!this.version.equals("null")) {
            return this.version;
        }
        return "";
    }

    public void setUserLevelDocumentation(String userLevelDocumentation) {
        this.userLevelDocumentation = userLevelDocumentation;
    }

    public String getUserLevelDocumentation() {
        if (this.userLevelDocumentation == null) {
            return "";
        }
        if (!this.userLevelDocumentation.equals("null")) {
            return this.userLevelDocumentation;
        }
        return "";
    }

    public void setPortHash(Hashtable portHash) {
        this.portHash = portHash;
    }

    public Hashtable getPortHash() {
        return this.portHash;
    }

    public void addPort(String name, String value) throws IllegalActionException, NameDuplicationException {
        this.portHash.put(name, value);
        new ConfigurableAttribute((NamedObj)this, "port:" + name);
    }

    public String getPort(String name) {
        return (String)this.portHash.get(name);
    }

    public void setPropertyHash(Hashtable propertyHash) {
        this.propertyHash = propertyHash;
    }

    public Hashtable getPropertyHash() {
        return this.propertyHash;
    }

    public void addProperty(String name, String value) throws NameDuplicationException, IllegalActionException {
        this.propertyHash.put(name, value);
        new ConfigurableAttribute((NamedObj)this, "prop:" + name);
    }

    public String getProperty(String name) {
        return (String)this.propertyHash.get(name);
    }

    public void configure(URL base, String source, String text) {
        this.source = source;
        this.text = text;
    }

    public String getConfigureSource() {
        return this.source;
    }

    public String getConfigureText() {
        return this.text;
    }
}

