/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.basic;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.EditParametersDialog;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.vergil.actor.DocApplicationSpecializer;
import ptolemy.vergil.basic.DocAttribute;
import ptolemy.vergil.toolbox.FigureAction;

public class CustomizeDocumentationAction
extends FigureAction {
    public CustomizeDocumentationAction() {
        super("Customize Documentation");
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        final NamedObj target = this.getTarget();
        boolean done = false;
        List docAttributeList = null;
        if (target != null) {
            Parameter docApplicationSpecializerParameter = null;
            try {
                List configsList = Configuration.configurations();
                Configuration config2 = null;
                for (Configuration config2 : configsList) {
                    if (config2 != null) break;
                }
                if (config2 == null) {
                    throw new InternalErrorException((Nameable)target, null, "Failed to find configuration");
                }
                docApplicationSpecializerParameter = (Parameter)config2.getAttribute("_docApplicationSpecializer", Parameter.class);
            }
            catch (IllegalActionException iae) {
                System.out.println("Error getting the documentation specializer: " + iae.getMessage());
            }
            if (docApplicationSpecializerParameter != null) {
                String docApplicationSpecializerClassName = docApplicationSpecializerParameter.getExpression();
                try {
                    Class<?> docApplicationSpecializerClass = Class.forName(docApplicationSpecializerClassName);
                    final DocApplicationSpecializer docApplicationSpecializer = (DocApplicationSpecializer)docApplicationSpecializerClass.newInstance();
                    String docAttributeClassName = docApplicationSpecializer.getDocumentationAttributeClassName();
                    Class<?> docAttributeClass = Class.forName(docAttributeClassName);
                    if (docApplicationSpecializerClass != null && docAttributeClass != null) {
                        docAttributeList = target.attributeList(docAttributeClass);
                    }
                    if (docAttributeList.size() == 0) {
                        docApplicationSpecializer.handleDocumentationAttributeDoesNotExist(this.getFrame(), target);
                    } else {
                        final Attribute docAttribute = (Attribute)docAttributeList.get(docAttributeList.size() - 1);
                        ChangeRequest request = new ChangeRequest(this, "Customize documentation."){

                            protected void _execute() throws Exception {
                                docApplicationSpecializer.editDocumentation(CustomizeDocumentationAction.this.getFrame(), docAttribute, target);
                            }
                        };
                        target.requestChange(request);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Failed to call doc application specializer class \"" + docApplicationSpecializerClassName + "\" on class \"" + docApplicationSpecializerClassName + "\".");
                }
                done = true;
            }
            if (!done) {
                Object request;
                docAttributeList = target.attributeList(DocAttribute.class);
                if (docAttributeList.size() == 0) {
                    String moml = "<property name=\"DocAttribute\" class=\"ptolemy.vergil.basic.DocAttribute\"/>";
                    request = new MoMLChangeRequest(this, target, moml){

                        protected void _execute() throws Exception {
                            super._execute();
                            List docAttributes = target.attributeList(DocAttribute.class);
                            DocAttribute attribute = (DocAttribute)((Object)docAttributes.get(docAttributes.size() - 1));
                            CustomizeDocumentationAction.this._editDocAttribute(CustomizeDocumentationAction.this.getFrame(), attribute, target);
                        }
                    };
                    target.requestChange((ChangeRequest)request);
                } else {
                    final DocAttribute attribute = (DocAttribute)((Object)docAttributeList.get(docAttributeList.size() - 1));
                    request = new ChangeRequest(this, "Customize documentation."){

                        protected void _execute() throws Exception {
                            attribute.refreshParametersAndPorts();
                            CustomizeDocumentationAction.this._editDocAttribute(CustomizeDocumentationAction.this.getFrame(), attribute, target);
                        }
                    };
                    target.requestChange((ChangeRequest)request);
                }
            }
        }
    }

    private void _editDocAttribute(Frame owner, DocAttribute attribute, NamedObj target) {
        new EditParametersDialog(owner, (NamedObj)attribute, "Edit Documentation for " + target.getName());
    }
}

