/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TableauFactory;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.actor.DocEffigy;
import ptolemy.vergil.actor.DocViewer;
import ptolemy.vergil.basic.DocAttribute;

public class DocTableau
extends Tableau {
    public DocTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        if (!(container instanceof DocEffigy)) {
            throw new IllegalActionException((Nameable)container, "Needs to be an instance of DocEffigy to contain a DocTableau.");
        }
        DocAttribute docAttribute = ((DocEffigy)container).getDocAttribute();
        if (docAttribute != null) {
            DocViewer frame = new DocViewer(docAttribute.getContainer(), (Configuration)container.toplevel());
            this.setFrame(frame);
            frame.setTableau(this);
        } else {
            try {
                URL effigyURL = container.uri.getURL();
                DocViewer frame = new DocViewer(effigyURL, (Configuration)container.toplevel());
                this.setFrame(frame);
                frame.setTableau(this);
            }
            catch (MalformedURLException e) {
                throw new IllegalActionException((Nameable)this, (Nameable)container, (Throwable)e, "Malformed URL");
            }
        }
    }

    public static class Factory
    extends TableauFactory {
        public Factory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        public Tableau createTableau(Effigy effigy) throws Exception {
            if (effigy instanceof DocEffigy) {
                effigy.setTableauFactory(this);
                DocTableau tableau = (DocTableau)effigy.getEntity("DocTableau");
                if (tableau == null) {
                    tableau = new DocTableau(effigy, "DocTableau");
                }
                return tableau;
            }
            return null;
        }
    }
}

