/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.actor;

import diva.canvas.DamageRegion;
import diva.graph.GraphController;
import diva.graph.GraphModel;
import diva.graph.GraphPane;
import diva.gui.GUIUtilities;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.Manager;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DebugListenerTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.PtolemyPreferences;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.actor.gui.UserActorLibrary;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.KernelRuntimeException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.LibraryAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.actor.ActorEditorGraphController;
import ptolemy.vergil.actor.ActorGraphModel;
import ptolemy.vergil.basic.AbstractBasicGraphModel;
import ptolemy.vergil.basic.ExtendedGraphFrame;

public class ActorGraphFrame
extends ExtendedGraphFrame {
    protected ActorEditorGraphController _controller;
    protected JMenu _debugMenu;
    protected JMenu _graphMenu;
    protected Action _createHierarchyAction;
    protected Action _layoutAction;
    protected Action _saveInLibraryAction;
    protected Action _importLibraryAction;
    protected Action _instantiateAttributeAction;
    protected Action _instantiateEntityAction;
    private String _lastAttributeClassName = "ptolemy.vergil.kernel.attributes.EllipseAttribute";
    private String _lastEntityClassName = "ptolemy.actor.lib.Ramp";
    private String _lastLocation = "";
    private long _lastDelayTime = 0L;

    public ActorGraphFrame(CompositeEntity entity, Tableau tableau) {
        this(entity, tableau, null);
    }

    public ActorGraphFrame(CompositeEntity entity, Tableau tableau, LibraryAttribute defaultLibrary) {
        super(entity, tableau, defaultLibrary);
        this.helpFile = "ptolemy/configs/doc/vergilGraphEditorHelp.htm";
        this._createHierarchyAction = new CreateHierarchyAction();
        this._layoutAction = new LayoutAction();
        this._saveInLibraryAction = new SaveInLibraryAction();
        this._importLibraryAction = new ImportLibraryAction();
        this._instantiateAttributeAction = new InstantiateAttributeAction();
        this._instantiateEntityAction = new InstantiateEntityAction();
    }

    protected void _addMenus() {
        super._addMenus();
        this._graphMenu = new JMenu("Graph");
        this._graphMenu.setMnemonic(71);
        this._menubar.add(this._graphMenu);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._layoutAction);
        GUIUtilities.addMenuItem((JMenu)this._graphMenu, (Action)this._layoutAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._saveInLibraryAction);
        GUIUtilities.addMenuItem((JMenu)this._graphMenu, (Action)this._saveInLibraryAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._importLibraryAction);
        GUIUtilities.addMenuItem((JMenu)this._graphMenu, (Action)this._importLibraryAction);
        GUIUtilities.addMenuItem((JMenu)this._graphMenu, (Action)this._instantiateAttributeAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._instantiateAttributeAction);
        GUIUtilities.addMenuItem((JMenu)this._graphMenu, (Action)this._instantiateEntityAction);
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._instantiateEntityAction);
        this._graphMenu.addSeparator();
        GUIUtilities.addHotKey((JComponent)this._getRightComponent(), (Action)this._createHierarchyAction);
        GUIUtilities.addMenuItem((JMenu)this._graphMenu, (Action)this._createHierarchyAction);
        this._graphMenu.addSeparator();
        this._controller.addToMenuAndToolbar(this._graphMenu, this._toolbar);
        JMenuItem[] debugMenuItems = new JMenuItem[]{new JMenuItem("Listen to Director", 76), new JMenuItem("Animate Execution", 65), new JMenuItem("Stop Animating", 83)};
        this._debugMenu = new JMenu("Debug");
        this._debugMenu.setMnemonic(68);
        DebugMenuListener debugMenuListener = new DebugMenuListener();
        int i = 0;
        while (i < debugMenuItems.length) {
            debugMenuItems[i].setActionCommand(debugMenuItems[i].getText());
            debugMenuItems[i].addActionListener(debugMenuListener);
            this._debugMenu.add(debugMenuItems[i]);
            ++i;
        }
        this._menubar.add(this._debugMenu);
    }

    protected boolean _close() {
        CompositeActor ptActorModel;
        Manager manager;
        NamedObj ptModel = this.getModel();
        if (ptModel instanceof CompositeActor && ptModel.getContainer() == null && (manager = (ptActorModel = (CompositeActor)ptModel).getManager()) != null) {
            manager.stop();
        }
        return super._close();
    }

    protected GraphPane _createGraphPane(NamedObj entity) {
        this._controller = new ActorEditorGraphController();
        this._controller.setConfiguration(this.getConfiguration());
        this._controller.setFrame(this);
        ActorGraphModel graphModel = new ActorGraphModel(entity);
        return new ActorGraphPane(this._controller, graphModel, entity);
    }

    private class ActorGraphPane
    extends GraphPane {
        private NamedObj _entity;

        public ActorGraphPane(ActorEditorGraphController controller, ActorGraphModel model, NamedObj entity) {
            super((GraphController)controller, (GraphModel)model);
            this._entity = entity;
        }

        public void repaint() {
            this._setBackground();
            super.repaint();
        }

        public void repaint(DamageRegion damage) {
            this._setBackground();
            super.repaint(damage);
        }

        private void _setBackground() {
            List list;
            if (this._entity != null && (list = this._entity.attributeList(PtolemyPreferences.class)).size() > 0) {
                PtolemyPreferences preferences = (PtolemyPreferences)((Object)list.get(list.size() - 1));
                this.getCanvas().setBackground(preferences.backgroundColor.asColor());
            }
        }
    }

    private class CreateHierarchyAction
    extends AbstractAction {
        public CreateHierarchyAction() {
            super("Create Hierarchy");
            this.putValue("tooltip", "Create a TypedCompositeActor that contains the selected actors.");
        }

        public void actionPerformed(ActionEvent e) {
            ActorGraphFrame.this.createHierarchy();
        }
    }

    public class DebugMenuListener
    implements ActionListener {
        private Director _listeningTo;

        public void actionPerformed(ActionEvent e) {
            block16: {
                JMenuItem target = (JMenuItem)e.getSource();
                String actionCommand = target.getActionCommand();
                try {
                    if (actionCommand.equals("Listen to Director")) {
                        Director director;
                        NamedObj model = ActorGraphFrame.this.getModel();
                        boolean success = false;
                        if (model instanceof Actor && (director = ((Actor)model).getDirector()) != null) {
                            Effigy effigy = (Effigy)ActorGraphFrame.this.getTableau().getContainer();
                            TextEffigy textEffigy = new TextEffigy(effigy, effigy.uniqueName("debug listener"));
                            DebugListenerTableau tableau = new DebugListenerTableau(textEffigy, textEffigy.uniqueName("debugListener"));
                            tableau.setDebuggable((Debuggable)director);
                            success = true;
                        }
                        if (!success) {
                            MessageHandler.error((String)"No director to listen to!");
                        }
                        break block16;
                    }
                    if (actionCommand.equals("Animate Execution")) {
                        NamedObj model = ActorGraphFrame.this.getModel();
                        if (model instanceof Actor) {
                            Query query = new Query();
                            query.addLine("delay", "Time (in ms) to hold highlight", Long.toString(ActorGraphFrame.this._lastDelayTime));
                            ComponentDialog dialog = new ComponentDialog((Frame)ActorGraphFrame.this, "Delay for Animation", query);
                            if (dialog.buttonPressed().equals("OK")) {
                                try {
                                    ActorGraphFrame.this._lastDelayTime = Long.parseLong(query.getStringValue("delay"));
                                    ActorGraphFrame.this._controller.setAnimationDelay(ActorGraphFrame.this._lastDelayTime);
                                    Director director = ((Actor)model).getDirector();
                                    while (director == null && model instanceof Actor) {
                                        if (!((model = model.getContainer()) instanceof Actor)) continue;
                                        director = ((Actor)model).getDirector();
                                    }
                                    if (director != null && this._listeningTo != director) {
                                        if (this._listeningTo != null) {
                                            this._listeningTo.removeDebugListener((DebugListener)ActorGraphFrame.this._controller);
                                        }
                                        director.addDebugListener((DebugListener)ActorGraphFrame.this._controller);
                                        this._listeningTo = director;
                                    }
                                    break block16;
                                }
                                catch (NumberFormatException ex) {
                                    MessageHandler.error((String)"Invalid time, which is required to be an integer", (Throwable)ex);
                                }
                                break block16;
                            }
                            MessageHandler.error((String)"Cannot find the director. Possibly this is because this is a class, not an instance.");
                            break block16;
                        }
                        MessageHandler.error((String)"Model is not an actor. Cannot animate.");
                        break block16;
                    }
                    if (actionCommand.equals("Stop Animating") && this._listeningTo != null) {
                        this._listeningTo.removeDebugListener((DebugListener)ActorGraphFrame.this._controller);
                        ActorGraphFrame.this._controller.clearAnimation();
                        this._listeningTo = null;
                    }
                }
                catch (KernelException ex) {
                    try {
                        MessageHandler.warning((String)("Failed to create debug listener: " + (Object)((Object)ex)));
                    }
                    catch (CancelException cancelException) {}
                }
            }
        }
    }

    private class ImportLibraryAction
    extends AbstractAction {
        public ImportLibraryAction() {
            super("Import Library");
            this.putValue("tooltip", "Import a library into the Palette");
            this.putValue("MnemonicKey", 77);
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Select a library");
            if (ActorGraphFrame.this._getDirectory() != null) {
                chooser.setCurrentDirectory(ActorGraphFrame.this._getDirectory());
            } else {
                String cwd = StringUtilities.getProperty((String)"user.dir");
                if (cwd != null) {
                    chooser.setCurrentDirectory(new File(cwd));
                }
            }
            int result = chooser.showOpenDialog(ActorGraphFrame.this);
            if (result == 0) {
                try {
                    File file = chooser.getSelectedFile();
                    PtolemyEffigy effigy = (PtolemyEffigy)ActorGraphFrame.this.getTableau().getContainer();
                    Configuration configuration = (Configuration)effigy.toplevel();
                    UserActorLibrary.openLibrary(configuration, file);
                    ActorGraphFrame.this._setDirectory(chooser.getCurrentDirectory());
                }
                catch (Throwable throwable) {
                    MessageHandler.error((String)"Library import failed.", (Throwable)throwable);
                }
            }
        }
    }

    private class InstantiateAttributeAction
    extends AbstractAction {
        public InstantiateAttributeAction() {
            super("Instantiate Attribute");
            this.putValue("tooltip", "Instantiate an attribute by class name");
            this.putValue("MnemonicKey", 65);
        }

        public void actionPerformed(ActionEvent e) {
            Query query = new Query();
            query.setTextWidth(60);
            query.addLine("class", "Class name", ActorGraphFrame.this._lastAttributeClassName);
            ComponentDialog dialog = new ComponentDialog((Frame)ActorGraphFrame.this, "Instantiate Attribute", query);
            if (dialog.buttonPressed().equals("OK")) {
                GraphController controller = ActorGraphFrame.this.getJGraph().getGraphPane().getGraphController();
                AbstractBasicGraphModel model = (AbstractBasicGraphModel)controller.getGraphModel();
                NamedObj context = model.getPtolemyModel();
                ActorGraphFrame.this._lastAttributeClassName = query.getStringValue("class");
                String rootName = ActorGraphFrame.this._lastAttributeClassName;
                int period = rootName.lastIndexOf(".");
                if (period >= 0 && rootName.length() > period + 1) {
                    rootName = rootName.substring(period + 1);
                }
                Rectangle2D bounds = ActorGraphFrame.this.getVisibleCanvasRectangle();
                double x = bounds.getWidth() / 2.0;
                double y = bounds.getHeight() / 2.0;
                String moml = "<group name=\"auto\"><property name=\"" + rootName + "\" class=\"" + ActorGraphFrame.this._lastAttributeClassName + "\"><property name=\"_location\" " + "class=\"ptolemy.kernel.util.Location\" value=\"" + x + ", " + y + "\"></property></property></group>";
                MoMLChangeRequest request = new MoMLChangeRequest((Object)this, context, moml);
                context.requestChange((ChangeRequest)request);
            }
        }
    }

    private class InstantiateEntityAction
    extends AbstractAction {
        public InstantiateEntityAction() {
            super("Instantiate Entity");
            this.putValue("tooltip", "Instantiate an entity by class name");
            this.putValue("MnemonicKey", 69);
        }

        public void actionPerformed(ActionEvent e) {
            Query query = new Query();
            query.setTextWidth(60);
            query.addLine("class", "Class name", ActorGraphFrame.this._lastEntityClassName);
            query.addLine("location", "Location (URL)", ActorGraphFrame.this._lastLocation);
            ComponentDialog dialog = new ComponentDialog((Frame)ActorGraphFrame.this, "Instantiate Entity", query);
            if (dialog.buttonPressed().equals("OK")) {
                GraphController controller = ActorGraphFrame.this.getJGraph().getGraphPane().getGraphController();
                AbstractBasicGraphModel model = (AbstractBasicGraphModel)controller.getGraphModel();
                NamedObj context = model.getPtolemyModel();
                ActorGraphFrame.this._lastEntityClassName = query.getStringValue("class");
                ActorGraphFrame.this._lastLocation = query.getStringValue("location");
                String rootName = ActorGraphFrame.this._lastEntityClassName;
                int period = rootName.lastIndexOf(".");
                if (period >= 0 && rootName.length() > period + 1) {
                    rootName = rootName.substring(period + 1);
                }
                Rectangle2D bounds = ActorGraphFrame.this.getVisibleCanvasRectangle();
                double x = bounds.getWidth() / 2.0;
                double y = bounds.getHeight() / 2.0;
                String source = "";
                if (!ActorGraphFrame.this._lastLocation.trim().equals("")) {
                    source = " source=\"" + ActorGraphFrame.this._lastLocation.trim() + "\"";
                }
                String moml = "<group name=\"auto\"><entity name=\"" + rootName + "\" class=\"" + ActorGraphFrame.this._lastEntityClassName + "\"" + source + "><property name=\"_location\" " + "class=\"ptolemy.kernel.util.Location\" value=\"" + x + ", " + y + "\"></property></entity></group>";
                MoMLChangeRequest request = new MoMLChangeRequest((Object)this, context, moml);
                context.requestChange((ChangeRequest)request);
            }
        }
    }

    private class LayoutAction
    extends AbstractAction {
        public LayoutAction() {
            super("Automatic Layout");
            this.putValue("tooltip", "Layout the Graph (Ctrl+T)");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("MnemonicKey", 76);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ActorGraphFrame.this.layoutGraph();
            }
            catch (Exception ex) {
                MessageHandler.error((String)"Layout failed", (Throwable)ex);
            }
        }
    }

    private class SaveInLibraryAction
    extends AbstractAction {
        public SaveInLibraryAction() {
            super("Save In Library");
            this.putValue("tooltip", "Save as a Component in Library");
            this.putValue("MnemonicKey", 83);
        }

        public void actionPerformed(ActionEvent e) {
            PtolemyEffigy effigy = (PtolemyEffigy)ActorGraphFrame.this.getTableau().getContainer();
            NamedObj object = effigy.getModel();
            if (object == null) {
                return;
            }
            if (!(object instanceof Entity)) {
                throw new KernelRuntimeException("Could not save in library, '" + object + "' is not an Entity");
            }
            Entity entity = (Entity)object;
            Configuration configuration = (Configuration)effigy.toplevel();
            try {
                UserActorLibrary.saveComponentInLibrary(configuration, entity);
            }
            catch (Exception exception) {
                MessageHandler.error((String)("Failed to save \"" + entity.getName() + "\"."));
            }
        }
    }
}

