/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui.unit;

import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.PtolemyDialog;
import ptolemy.data.unit.UnitAttribute;
import ptolemy.data.unit.UnitEquation;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLChangeRequest;

public class UnitConstraintsDialog
extends PtolemyDialog
implements ChangeListener {
    private JButton _addButton;
    private JButton _applyButton;
    private JButton _commitButton;
    private JButton _removeButton;
    private ListSelectionListener _rowSelectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                UnitConstraintsDialog.this._removeButton.setText("Remove");
                UnitConstraintsDialog.this._removeButton.setEnabled(false);
            } else {
                UnitConstraintsDialog.this._removeButton.setEnabled(true);
            }
        }
    };
    private JTable _unitsTable;
    private UnitsTableModel _unitsTableModel;

    public UnitConstraintsDialog(DialogTableau tableau, Frame owner, Entity target, Configuration configuration) {
        super("Configure units for " + target.getName(), tableau, owner, target, configuration);
        Vector<String> _constraintExpression = new Vector<String>();
        UnitAttribute _unitConstraints = (UnitAttribute)target.getAttribute("_unitConstraints");
        if (_unitConstraints != null) {
            Vector _constraintExpressions = _unitConstraints.getUnitConstraints().getConstraints();
            int i = 0;
            while (i < _constraintExpressions.size()) {
                UnitEquation uEq = (UnitEquation)_constraintExpressions.get(i);
                String commonDesc = uEq.descriptiveForm();
                System.out.println("_constraint " + commonDesc);
                _constraintExpression.add(commonDesc);
                ++i;
            }
        }
        this._unitsTable = new JTable();
        this._unitsTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.setScrollableContents(this._unitsTable);
        ListSelectionModel rowSM = this._unitsTable.getSelectionModel();
        rowSM.addListSelectionListener(this._rowSelectionListener);
        this._setupTableModel(_constraintExpression);
        this._unitsTable.setTableHeader(null);
        this.pack();
        this.setVisible(true);
    }

    public void changeExecuted(ChangeRequest change) {
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
    }

    protected void _apply() {
        String expr = this._unitsTableModel.toString();
        String moml = "<property name=\"_unitConstraints\" class = \"ptolemy.data.unit.UnitAttribute\" value = \"" + expr + "\"/>";
        MoMLChangeRequest request = new MoMLChangeRequest((Object)this, (NamedObj)this.getTarget(), moml, null);
        request.setUndoable(true);
        this.getTarget().requestChange((ChangeRequest)request);
    }

    protected void _createExtendedButtons(JPanel _buttons) {
        this._commitButton = new JButton("Commit");
        _buttons.add(this._commitButton);
        this._applyButton = new JButton("Apply");
        _buttons.add(this._applyButton);
        this._addButton = new JButton("Add");
        _buttons.add(this._addButton);
        this._removeButton = new JButton("Remove           ");
        this._removeButton.setEnabled(false);
        _buttons.add(this._removeButton);
    }

    protected void _enableApplyButton(boolean enabled) {
        this._applyButton.setEnabled(enabled);
    }

    protected URL _getHelpURL() {
        URL helpURL = this.getClass().getClassLoader().getResource("ptolemy/actor/gui/doc/unitConstraintsDialog.htm");
        return helpURL;
    }

    protected void _processButtonPress(String button) {
        if (button.equals("Add")) {
            this._unitsTableModel.addNewConstraint();
        } else if (button.equals("Apply")) {
            this._apply();
        } else {
            super._processButtonPress(button);
        }
    }

    private void _setupTableModel(Vector constraintExpressions) {
        this._unitsTableModel = new UnitsTableModel(constraintExpressions);
        this._unitsTable.setModel(this._unitsTableModel);
        TableColumn _constraintColumn = this._unitsTable.getColumnModel().getColumn(0);
        JTextField textField = new JTextField();
        DefaultCellEditor constraintEditor = new DefaultCellEditor(textField);
        constraintEditor.setClickCountToStart(1);
        _constraintColumn.setCellEditor(constraintEditor);
        this._enableApplyButton(false);
    }

    class UnitsTableModel
    extends AbstractTableModel {
        Vector _unitsDataTable;

        public UnitsTableModel(Vector unitsExpression) {
            this._unitsDataTable = new Vector(unitsExpression);
        }

        public int getRowCount() {
            return this._unitsDataTable.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int i) {
            return "Constraint";
        }

        public Object getValueAt(int row, int col) {
            return this._unitsDataTable.elementAt(row);
        }

        public void addNewConstraint() {
            this._unitsDataTable.add("");
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        }

        public boolean isCellEditable(int arg0, int arg1) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            this._unitsDataTable.set(row, value);
            UnitConstraintsDialog.this._enableApplyButton(true);
            UnitConstraintsDialog.this._setDirty(true);
        }

        public String toString() {
            StringBuffer retv = new StringBuffer("");
            if (this._unitsDataTable.size() > 0) {
                retv.append((String)this._unitsDataTable.elementAt(0));
                int i = 1;
                while (i < this._unitsDataTable.size()) {
                    retv.append(";" + (String)this._unitsDataTable.elementAt(i));
                    ++i;
                }
            }
            return retv.toString();
        }
    }
}

