/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import ptolemy.actor.gui.DialogTableau;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PortConfigurerDialog;
import ptolemy.actor.gui.SizeAttribute;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class Tableau
extends CompositeEntity {
    public SizeAttribute size = new SizeAttribute((NamedObj)this, "size");
    private boolean _editable;
    private JFrame _frame;
    private boolean _master = false;
    private String _title;

    public Tableau(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
    }

    public Tableau(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.size && this._frame != null) {
            this.size.setSize(this._frame);
        } else {
            super.attributeChanged(attribute);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Tableau newObject = (Tableau)((Object)super.clone(workspace));
        newObject._frame = null;
        return newObject;
    }

    public boolean close() {
        JFrame frame = this.getFrame();
        if (frame instanceof TableauFrame) {
            if (!((TableauFrame)frame)._close()) {
                return false;
            }
        } else if (this instanceof DialogTableau && frame instanceof PortConfigurerDialog) {
            if (!((PortConfigurerDialog)frame).close()) {
                return false;
            }
        } else if (frame != null) {
            frame.dispose();
        }
        return true;
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public String getTitle() {
        if (this._title == null) {
            Effigy effigy = (Effigy)this.getContainer();
            return StringUtilities.abbreviate((String)effigy.identifier.getExpression());
        }
        return this._title;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isMaster() {
        return this._master;
    }

    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        if (container == null) {
            Effigy oldContainer = (Effigy)this.getContainer();
            super.setContainer(null);
            if (this._frame != null) {
                this._frame.setVisible(false);
            }
            if (this.isMaster() && oldContainer != null) {
                oldContainer.setContainer(null);
            }
        } else if (container instanceof Effigy) {
            super.setContainer(container);
        } else {
            throw new IllegalActionException((Nameable)this, (Nameable)container, "The container can only be set to an instance of Effigy");
        }
    }

    public void setEditable(boolean flag) {
        this._editable = flag;
    }

    public void setFrame(JFrame frame) throws IllegalActionException {
        this._frame = frame;
        this.size.setSize(frame);
        frame.setTitle(this.getTitle());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                try {
                    Tableau.this.setContainer(null);
                }
                catch (KernelException ex) {
                    try {
                        MessageHandler.warning((String)("Cannot remove tableau: " + (Object)((Object)ex)));
                    }
                    catch (CancelException cancelException) {}
                }
            }
        });
    }

    public void setMaster(boolean flag) {
        this._master = flag;
    }

    public void setTitle(String title) {
        this._title = StringUtilities.abbreviate((String)title);
        if (this._frame != null) {
            this._frame.setTitle(this.getTitle());
        }
    }

    public void show() {
        JFrame frame = this.getFrame();
        if (frame != null) {
            if (!frame.isVisible()) {
                this.size.setSize(frame);
                frame.pack();
                frame.setVisible(true);
            }
            frame.setState(0);
            frame.toFront();
        }
    }
}

