/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Frame;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Configurer;
import ptolemy.actor.gui.HTMLViewer;
import ptolemy.actor.gui.TableauFrame;
import ptolemy.actor.gui.style.StyleConfigurer;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.CancelException;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class EditParametersDialog
extends ComponentDialog
implements ChangeListener {
    protected Frame _owner;
    protected Query _query;
    protected NamedObj _target;
    private static String[] _moreButtons = new String[]{"Commit", "Add", "Remove", "Restore Defaults", "Preferences", "Help", "Cancel"};

    public EditParametersDialog(Frame owner, NamedObj target) {
        this(owner, target, "Edit parameters for " + target.getName());
    }

    public EditParametersDialog(Frame owner, NamedObj target, String label) {
        super(owner, label, new Configurer(target), _moreButtons);
        this._owner = owner;
        this._target = target;
        if (this.buttonPressed().equals("Add")) {
            this._openAddDialog(null, "", "", "ptolemy.data.expr.Parameter");
            this._target.removeChangeListener((ChangeListener)this);
        } else if (this.buttonPressed().equals("Remove")) {
            List attributeList = this._target.attributeList(Settable.class);
            Iterator parameters = attributeList.iterator();
            int count = 0;
            while (parameters.hasNext()) {
                Settable parameter = (Settable)parameters.next();
                if (!Configurer.isVisible(target, parameter)) continue;
                ++count;
            }
            String[] attributeNames = new String[count];
            parameters = attributeList.iterator();
            int index = 0;
            while (parameters.hasNext()) {
                Settable parameter = (Settable)parameters.next();
                if (!Configurer.isVisible(target, parameter)) continue;
                attributeNames[index++] = ((Attribute)parameter).getName();
            }
            Query query = new Query();
            query.addChoice("delete", "Parameter to delete", attributeNames, null, false);
            ComponentDialog dialog = new ComponentDialog(this._owner, "Delete a parameter for " + this._target.getFullName(), query, null);
            String deleteName = query.getStringValue("delete");
            if (dialog.buttonPressed().equals("OK") && !deleteName.equals("")) {
                String moml = "<deleteProperty name=\"" + deleteName + "\"/>";
                this._target.addChangeListener((ChangeListener)this);
                MoMLChangeRequest request = new MoMLChangeRequest((Object)this, this._target, moml);
                request.setUndoable(true);
                this._target.requestChange((ChangeRequest)request);
            }
        } else if (this.buttonPressed().equals("Restore Defaults")) {
            ((Configurer)this.contents).restoreToDefaults();
            new EditParametersDialog(this._owner, this._target);
        } else if (this.buttonPressed().equals("Preferences")) {
            try {
                StyleConfigurer panel = new StyleConfigurer(target);
                ComponentDialog dialog = new ComponentDialog(this._owner, "Edit preferences for " + target.getName(), panel);
                if (!dialog.buttonPressed().equals("OK")) {
                    panel.restore();
                }
                new EditParametersDialog(this._owner, this._target);
            }
            catch (IllegalActionException ex) {
                MessageHandler.error((String)"Edit Parameter Styles failed", (Throwable)ex);
            }
        } else if (this.buttonPressed().equals("Help")) {
            try {
                Configuration configuration;
                URL doc = this.getClass().getClassLoader().getResource("doc/expressions.htm");
                boolean success = false;
                if (this._owner instanceof TableauFrame && (configuration = ((TableauFrame)this._owner).getConfiguration()) != null) {
                    configuration.openModel(null, doc, doc.toExternalForm());
                    success = true;
                }
                if (!success) {
                    HTMLViewer viewer = new HTMLViewer();
                    viewer.setPage(doc);
                    viewer.pack();
                    viewer.show();
                }
            }
            catch (Exception ex) {
                try {
                    MessageHandler.warning((String)"Cannot open help page.", (Throwable)ex);
                }
                catch (CancelException cancelException) {}
            }
        }
    }

    public void changeExecuted(ChangeRequest change) {
        if (change == null || change.getSource() != this) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new EditParametersDialog(EditParametersDialog.this._owner, EditParametersDialog.this._target);
            }
        });
        this._target.removeChangeListener((ChangeListener)this);
    }

    public void changeFailed(ChangeRequest change, final Exception exception) {
        if (change == null || change.getSource() != this) {
            return;
        }
        this._target.removeChangeListener((ChangeListener)this);
        if (change.isErrorReported()) {
            return;
        }
        change.setErrorReported(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (EditParametersDialog.this._query == null) {
                    return;
                }
                String newName = EditParametersDialog.this._query.getStringValue("name");
                ComponentDialog dialog = EditParametersDialog.this._openAddDialog(String.valueOf(exception.getMessage()) + "\n\nPlease enter a new default value:", newName, EditParametersDialog.this._query.getStringValue("default"), EditParametersDialog.this._query.getStringValue("class"));
                EditParametersDialog.this._target.removeChangeListener((ChangeListener)EditParametersDialog.this);
                if (!dialog.buttonPressed().equals("OK")) {
                    String moml = "<deleteProperty name=\"" + newName + "\"/>";
                    MoMLChangeRequest request = new MoMLChangeRequest((Object)this, EditParametersDialog.this._target, moml);
                    request.setUndoable(true);
                    EditParametersDialog.this._target.requestChange((ChangeRequest)request);
                }
            }
        });
    }

    protected void _handleClosing() {
        super._handleClosing();
        if (!(this.buttonPressed().equals("Commit") || this.buttonPressed().equals("Add") || this.buttonPressed().equals("Preferences") || this.buttonPressed().equals("Help") || this.buttonPressed().equals("Remove"))) {
            ((Configurer)this.contents).restore();
        }
    }

    protected ComponentDialog _openAddDialog(String message, String name, String defValue, String className) {
        this._query = new Query();
        if (message != null) {
            this._query.setMessage(message);
        }
        this._query.addLine("name", "Name", name);
        this._query.addLine("default", "Default value", defValue);
        this._query.addLine("class", "Class", className);
        ComponentDialog dialog = new ComponentDialog(this._owner, "Add a new parameter to " + this._target.getFullName(), this._query, null);
        String newName = this._query.getStringValue("name");
        String newDefValue = StringUtilities.escapeForXML((String)this._query.getStringValue("default"));
        if (dialog.buttonPressed().equals("OK") && !newName.equals("")) {
            String moml = "<property name=\"" + newName + "\" value=\"" + newDefValue + "\" class=\"" + this._query.getStringValue("class") + "\"/>";
            this._target.addChangeListener((ChangeListener)this);
            MoMLChangeRequest request = new MoMLChangeRequest((Object)this, this._target, moml);
            request.setUndoable(true);
            this._target.requestChange((ChangeRequest)request);
        }
        return dialog;
    }
}

