/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.Frame;
import java.lang.reflect.Constructor;
import javax.swing.JFrame;
import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PtolemyDialog;
import ptolemy.actor.gui.PtolemyEffigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.util.MessageHandler;

public class DialogTableau
extends Tableau {
    public DialogTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container.workspace());
        this.setName(name);
        this.setContainer(container);
    }

    public static DialogTableau createDialog(Frame parent, Configuration configuration, Effigy effigy, Class dialogClass, Entity target) {
        if (PtolemyDialog.class.isAssignableFrom(dialogClass)) {
            for (DialogTableau dialogTableau : effigy.entityList(DialogTableau.class)) {
                PtolemyDialog existingDialog = (PtolemyDialog)dialogTableau.getFrame();
                if (existingDialog == null || existingDialog.getClass() != dialogClass || !dialogTableau.hasTarget(target)) continue;
                return dialogTableau;
            }
            NamedObj container = effigy.getContainer();
            if (container != null && container instanceof PtolemyEffigy) {
                for (DialogTableau dialogTableau : ((PtolemyEffigy)container).entityList(DialogTableau.class)) {
                    PtolemyDialog existingDialog = (PtolemyDialog)dialogTableau.getFrame();
                    if (existingDialog.getClass() != dialogClass || !dialogTableau.hasTarget(target)) continue;
                    return dialogTableau;
                }
            }
        }
        try {
            DialogTableau newDialogTableau = new DialogTableau(effigy, effigy.uniqueName("dialog"));
            PtolemyDialog dialog = null;
            Constructor<?>[] constructors = dialogClass.getConstructors();
            Constructor<?> constructor = null;
            int i = 0;
            while (i < constructors.length) {
                Class<?>[] pType = constructors[i].getParameterTypes();
                if (pType.length == 4 && pType[0] == DialogTableau.class && pType[1] == Frame.class && pType[2] == Entity.class && pType[3] == Configuration.class) {
                    constructor = constructors[i];
                    break;
                }
                ++i;
            }
            if (constructor != null) {
                Object[] args = new Object[]{newDialogTableau, parent, target, configuration};
                dialog = (PtolemyDialog)constructor.newInstance(args);
            }
            if (dialog == null) {
                throw new KernelException((Nameable)target, null, "Can't create a " + dialogClass);
            }
            newDialogTableau.setFrame(dialog);
            return newDialogTableau;
        }
        catch (Throwable throwable) {
            MessageHandler.error((String)("Failed to create a DialogTableau for " + target.getFullName()), (Throwable)throwable);
            return null;
        }
    }

    public Entity getTarget() {
        JFrame dialogJFrame = this.getFrame();
        if (dialogJFrame instanceof PtolemyDialog) {
            PtolemyDialog dialog = (PtolemyDialog)dialogJFrame;
            return dialog.getTarget();
        }
        return null;
    }

    public boolean hasTarget(Entity entity) {
        Entity target = this.getTarget();
        return target != null && target == entity;
    }
}

