/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.Tableau;
import ptolemy.actor.gui.TextEditor;
import ptolemy.actor.gui.TextEffigy;
import ptolemy.kernel.util.DebugEvent;
import ptolemy.kernel.util.DebugListener;
import ptolemy.kernel.util.Debuggable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class DebugListenerTableau
extends Tableau {
    private Debuggable _debug;

    public DebugListenerTableau(Effigy container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        DebugListenerFrame frame = new DebugListenerFrame();
        this.setFrame(frame);
        frame.setTableau(this);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DebugListenerTableau.this.setDebuggable(null);
            }
        });
        if (container instanceof TextEffigy) {
            ((TextEffigy)container).setDocument(frame.text.getDocument());
        }
        frame.setVisible(true);
        frame.pack();
    }

    public Debuggable getDebuggable() {
        return this._debug;
    }

    public void setDebuggable(Debuggable debuggable) {
        if (this._debug != null) {
            this._debug.removeDebugListener((DebugListener)((DebugListenerFrame)this.getFrame()));
        }
        this._debug = debuggable;
        if (this._debug != null) {
            DebugListenerFrame debugFrame = (DebugListenerFrame)this.getFrame();
            this._debug.addDebugListener((DebugListener)debugFrame);
            debugFrame.setTitle(((NamedObj)this._debug).getFullName());
        }
    }

    public static class DebugListenerFrame
    extends TextEditor
    implements DebugListener {
        public DebugListenerFrame() {
            this.text.setEditable(false);
            this.text.setColumns(80);
            this.text.setRows(20);
            this.pack();
        }

        public void event(DebugEvent event) {
            this.text.append(String.valueOf(event.toString()) + "\n");
            this.scrollToEnd();
        }

        public void message(String message) {
            this.text.append(String.valueOf(message) + "\n");
            this.scrollToEnd();
        }
    }
}

